/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;

@XMLCalabash(name="cx:set-cookies", type="{http://xmlcalabash.com/ns/extensions}set-cookies")
public class SetCookies
extends DefaultStep {
    private static final QName _cookies = new QName("", "cookies");
    private static final QName _domain = new QName("", "domain");
    private static final QName _name = new QName("", "name");
    private static final QName _value = new QName("", "value");
    private static final QName _path = new QName("", "path");
    private static final QName _expires = new QName("", "expires");
    private static final QName _version = new QName("", "version");
    private static final QName _secure = new QName("", "secure");
    private static final QName c_cookies = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "cookies");
    private static final QName c_cookie = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "cookie");
    private static final DateFormat iso8601tz = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final DateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private ReadablePipe source = null;

    public SetCookies(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String cookieKey = this.getOption(_cookies).getString();
        XdmNode doc = this.source.read();
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        if (!c_cookies.equals((Object)root.getNodeName())) {
            throw new XProcException(this.step.getNode(), "The input to cx:set-cookies must be a c:cookies document.");
        }
        for (XdmNode node : new AxisNodes(root, Axis.CHILD, 7)) {
            if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (!c_cookie.equals((Object)node.getNodeName())) {
                    throw new XProcException(this.step.getNode(), "A c:cookies document must contain only c:cookie elements.");
                }
                String domain = node.getAttributeValue(_domain);
                String name = node.getAttributeValue(_name);
                String value = node.getAttributeValue(_value);
                String path = node.getAttributeValue(_path);
                String expires = node.getAttributeValue(_expires);
                if (name == null || value == null) {
                    throw new XProcException(this.step.getNode(), "Invalid cookie: " + node);
                }
                BasicClientCookie cookie = new BasicClientCookie(name, value);
                if (domain != null) {
                    cookie.setDomain(domain);
                }
                if (path != null) {
                    cookie.setPath(path);
                }
                if (expires != null) {
                    Date date = null;
                    try {
                        if (expires.length() > 21) {
                            expires = expires.substring(0, 22) + expires.substring(23);
                            date = iso8601tz.parse(expires);
                        } else {
                            date = iso8601.parse(expires);
                        }
                        cookie.setExpiryDate(date);
                    }
                    catch (ParseException pe) {
                        throw new XProcException(pe);
                    }
                }
                this.runtime.getCookieStore(cookieKey).addCookie((Cookie)cookie);
                continue;
            }
            if (node.getNodeKind() != XdmNodeKind.TEXT) continue;
            throw new XProcException(this.step.getNode(), "A c:cookies document must not contain non-whitespace text nodes.");
        }
    }
}

