/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import java.util.HashSet;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="cx:namespace-delete", type="{http://xmlcalabash.com/ns/extensions}namespace-delete")
public class NamespaceDelete
extends DefaultStep {
    private static final QName _prefixes = new QName("", "prefixes");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public NamespaceDelete(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        HashSet<NamespaceUri> excludeUris = S9apiUtils.excludeInlinePrefixes(this.step.getNode(), this.getOption(_prefixes).getString());
        while (this.source.moreDocuments()) {
            XdmNode doc = this.source.read();
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Namespace-delete step " + this.step.getName() + " read " + doc.getDocumentURI()));
            doc = S9apiUtils.removeNamespaces(this.runtime, doc, excludeUris, false);
            this.result.write(doc);
        }
    }
}

