/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="cx:java-properties", type="{http://xmlcalabash.com/ns/extensions}java-properties")
public class JavaProperties
extends DefaultStep {
    private static final String ACCEPT_TEXT = "text/plain, text/*, */*";
    private static final QName c_param_set = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "param-set");
    private static final QName c_param = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "param");
    private static final QName _href = new QName("", "href");
    private static final QName _name = new QName("name");
    private static final QName _namespace = new QName("namespace");
    private static final QName _value = new QName("value");
    private WritablePipe result = null;

    public JavaProperties(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        Properties properties;
        super.run();
        String pFn = null;
        URI pURI = null;
        if (this.getOption(_href) != null) {
            pFn = this.getOption(_href).getString();
            pURI = this.getOption(_href).getBaseURI();
        }
        if (pURI == null) {
            properties = System.getProperties();
        } else {
            properties = new Properties();
            try {
                String base = pURI.toASCIIString();
                DataStore store = this.runtime.getDataStore();
                store.readEntry(pFn, base, ACCEPT_TEXT, null, new DataStore.DataReader(){

                    @Override
                    public void load(URI id, String media, InputStream stream, long len) throws IOException {
                        properties.load(stream);
                    }
                });
            }
            catch (IOException mue) {
                throw new XProcException(XProcException.err_E0001, (Throwable)mue);
            }
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(c_param_set);
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            EmptyAttributeMap amap = EmptyAttributeMap.getInstance();
            amap = amap.put(TypeUtils.attributeInfo(_name, name));
            amap = amap.put(TypeUtils.attributeInfo(_namespace, ""));
            amap = amap.put(TypeUtils.attributeInfo(_value, value));
            tree.addStartElement(c_param, (AttributeMap)amap);
            tree.addEndElement();
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

