/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.config.CssProcessor;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="cx:css-formatter", type="{http://xmlcalabash.com/ns/extensions}css-formatter")
public class CssFormatter
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName _css = new QName("", "css");
    private static final QName _content_type = new QName("", "content-type");
    private ReadablePipe source = null;
    private ReadablePipe css = null;
    private WritablePipe result = null;
    private Properties options = new Properties();

    public CssFormatter(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else {
            this.css = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        if (NamespaceUri.NULL != name.getNamespaceUri()) {
            throw new XProcException(this.step.getNode(), "The cx:css-formatter parameters are in no namespace: " + name + " (" + name.getNamespaceUri().toString() + ")");
        }
        this.options.setProperty(name.getLocalName(), value.getString());
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        CssProcessor provider;
        super.run();
        String cssClass = this.runtime.getConfiguration().cssProcessor;
        if (cssClass == null) {
            throw new XProcException("No CSS processor class defined");
        }
        try {
            provider = (CssProcessor)Class.forName(cssClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            provider.initialize(this.runtime, this.step, this.options);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            throw new XProcException(this.step.getNode(), "Failed to instantiate CSS provider");
        }
        while (this.css != null && this.css.moreDocuments()) {
            XdmNode style = this.css.read();
            provider.addStylesheet(style);
        }
        final String contentType = this.getOption(_content_type) != null ? this.getOption(_content_type).getString() : "application/pdf";
        if (this.getOption(_css) != null) {
            String s = this.getOption(_css).getString();
            for (String css : s.split("\\s+")) {
                provider.addStylesheet(css);
            }
        }
        String href = this.getOption(_href).getString();
        String base = this.getOption(_href).getBaseURI().toASCIIString();
        try {
            DataStore store = this.runtime.getDataStore();
            URI id = store.writeEntry(href, base, contentType, new DataStore.DataWriter(){

                @Override
                public void store(OutputStream out) {
                    provider.format(CssFormatter.this.source.read(), out, contentType);
                }
            });
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(XProcConstants.c_result);
            tree.addText(id.toASCIIString());
            tree.addEndElement();
            tree.endDocument();
            this.result.write(tree.getResult());
        }
        catch (XProcException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() instanceof SaxonApiException) {
                throw (SaxonApiException)e.getCause();
            }
            throw new XProcException(this.step.getNode(), "Failed to style with CSS document", (Throwable)e);
        }
    }
}

