/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class XProcException
extends RuntimeException {
    public static final QName err_E0001 = XProcConstants.qNameFor(XProcConstants.NS_XPROC_ERROR_EX, "XE0001");
    public static final QName err_E0002 = XProcConstants.qNameFor(XProcConstants.NS_XPROC_ERROR_EX, "XE0002");
    private QName error = null;
    private Step step = null;
    private XdmNode node = null;

    public XProcException() {
    }

    public XProcException(String message) {
        super(message);
    }

    public XProcException(Step step, String message) {
        super(message);
        this.step = step;
    }

    public XProcException(XdmNode node, String message) {
        super(message);
        this.node = node;
    }

    public XProcException(String message, Throwable cause) {
        super(message, cause);
    }

    public XProcException(Step step, String message, Throwable cause) {
        super(message, cause);
        this.step = step;
    }

    public XProcException(Throwable cause) {
        super(cause);
    }

    public XProcException(XdmNode node, Throwable cause) {
        super(cause);
        this.node = node;
    }

    public XProcException(XdmNode node, String message, Throwable cause) {
        super(message, cause);
        this.node = node;
    }

    public XProcException(QName errorCode) {
        super(errorCode.getLocalName());
        this.error = errorCode;
    }

    public XProcException(Step step, QName errorCode) {
        super(errorCode.getLocalName());
        this.error = errorCode;
        this.step = step;
    }

    public XProcException(QName errorCode, String message) {
        super(message);
        this.error = errorCode;
    }

    public XProcException(Step step, QName errorCode, String message) {
        super(message);
        this.error = errorCode;
        this.step = step;
    }

    public XProcException(QName errorCode, XdmNode node, Throwable cause, String message) {
        super(message, cause);
        this.error = errorCode;
        this.node = node;
    }

    public XProcException(QName errorCode, XdmNode node, String message) {
        super(message);
        this.error = errorCode;
        this.node = node;
    }

    public XProcException(QName errorCode, Throwable cause) {
        super("XProc error err:" + errorCode.getLocalName(), cause);
        this.error = errorCode;
    }

    public static XProcException staticError(int errno) {
        return new XProcException(XProcConstants.staticError(errno));
    }

    public static XProcException staticError(int errno, String message) {
        return new XProcException(XProcConstants.staticError(errno), message);
    }

    public static XProcException staticError(int errno, XdmNode node, String message) {
        return new XProcException(XProcConstants.staticError(errno), node, message);
    }

    public static XProcException staticError(int errno, XdmNode node, Throwable cause, String message) {
        return new XProcException(XProcConstants.staticError(errno), node, cause, message);
    }

    public static XProcException staticError(int errno, Exception except) {
        return new XProcException(XProcConstants.staticError(errno), (Throwable)except);
    }

    public static XProcException dynamicError(int errno) {
        return new XProcException(XProcConstants.dynamicError(errno));
    }

    public static XProcException dynamicError(Step step, int errno) {
        return new XProcException(step, XProcConstants.dynamicError(errno));
    }

    public static XProcException dynamicError(int errno, String message) {
        return new XProcException(XProcConstants.dynamicError(errno), message);
    }

    public static XProcException dynamicError(int errno, XdmNode node, String message) {
        return new XProcException(XProcConstants.dynamicError(errno), node, message);
    }

    public static XProcException dynamicError(int errno, XdmNode node, Exception except, String message) {
        return new XProcException(XProcConstants.dynamicError(errno), node, except, message);
    }

    public static XProcException dynamicError(Step step, int errno, String message) {
        return new XProcException(step, XProcConstants.dynamicError(errno), message);
    }

    public static XProcException dynamicError(int errno, Exception except) {
        return new XProcException(XProcConstants.dynamicError(errno), (Throwable)except);
    }

    public static XProcException stepError(int errno) {
        return new XProcException(XProcConstants.stepError(errno));
    }

    public static XProcException stepError(int errno, String message) {
        return new XProcException(XProcConstants.stepError(errno), message);
    }

    public static XProcException stepError(int errno, Exception except) {
        return new XProcException(XProcConstants.stepError(errno), (Throwable)except);
    }

    public QName getErrorCode() {
        return this.error;
    }

    public Step getStep() {
        return this.step;
    }

    public XdmNode getNode() {
        return this.node;
    }

    public SourceLocator getLocator() {
        XdmNode locNode = null;
        if (this.step != null) {
            locNode = this.step.getNode();
        }
        if (this.node != null) {
            locNode = this.node;
        }
        return new ExceptionLocation(locNode);
    }

    private class ExceptionLocation
    implements SourceLocator {
        private int line = -1;
        private int col = -1;
        private String systemId = null;

        public ExceptionLocation(XdmNode node) {
            if (node != null) {
                URI cwd = URIUtils.cwdAsURI();
                this.systemId = cwd.relativize(node.getBaseURI()).toASCIIString();
                this.line = node.getLineNumber();
                this.col = node.getColumnNumber();
            }
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public int getColumnNumber() {
            return this.col;
        }
    }
}

