/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xsd;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.schematron.SchematronNodeRendererCustomizer;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XSDNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)XSDNodeRendererCustomizer.class.getName());
    private final SchematronNodeRendererCustomizer schNodeRendererCustomizer = new SchematronNodeRendererCustomizer();
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();

    private static String getImageURL(String path) {
        URL imageURL = XSDNodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(XSDNodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            String nodeNS = context.getNodeNamespace();
            String iconPath = null;
            if ("http://www.w3.org/2001/XMLSchema".equals(nodeNS)) {
                String nameWithoutPrefix = nodeName.indexOf(":") != -1 ? nodeName.substring(nodeName.indexOf(":") + 1) : nodeName;
                iconPath = nameToIconPath.get(nameWithoutPrefix);
                renderingInfo.setIconPath(iconPath);
            } else if ("http://www.ascc.net/xml/schematron".equals(nodeNS) || "http://purl.oclc.org/dsdl/schematron".equals(nodeNS)) {
                return this.schNodeRendererCustomizer.getRenderingInformation(context);
            }
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "XML Schema Node Renderer Customizer";
    }

    static {
        nameToIconPath.put("assert", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/Assert16.png"));
        nameToIconPath.put("alternative", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/Alternative16.png"));
        nameToIconPath.put("attribute", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/AttributeDeclaration16.png"));
        nameToIconPath.put("attributeGroup", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/AttributeGroup16.png"));
        nameToIconPath.put("element", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementDeclaration16.gif"));
        nameToIconPath.put("group", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ModelGroup16.png"));
        nameToIconPath.put("notation", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/Notation16.png"));
        nameToIconPath.put("complexType", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ComplexType16.png"));
        nameToIconPath.put("simpleType", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/SimpleType16.png"));
        nameToIconPath.put("import", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/Import16.png"));
        nameToIconPath.put("include", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/Include16.png"));
        nameToIconPath.put("redefine", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/Redefine16.png"));
        nameToIconPath.put("all", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementAll16.png"));
        nameToIconPath.put("choice", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementChoice16.png"));
        nameToIconPath.put("sequence", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementSequence16.png"));
        nameToIconPath.put("schema", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementSchema16.png"));
        nameToIconPath.put("openContent", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOpenContent16.png"));
        nameToIconPath.put("defaultOpenContent", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOpenContent16.png"));
        nameToIconPath.put("override", XSDNodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOverride16.png"));
    }
}

