/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.wsdl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.xsd.XSDNodeRendererCustomizer;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class WSDLNodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)WSDLNodeRendererCustomizer.class.getName());
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();
    private final XSDNodeRendererCustomizer xsdNodeRendererCustomizer = new XSDNodeRendererCustomizer();

    private static String getImageURL(String path) {
        URL imageURL = WSDLNodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(WSDLNodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            String nodeNS = context.getNodeNamespace();
            String iconPath = null;
            if ("http://schemas.xmlsoap.org/wsdl/".equals(nodeNS)) {
                String parentElement;
                int index = nodeName.indexOf(":");
                Object imageKey = index == -1 ? nodeName : nodeName.substring(index + 1);
                if ("operation".equals(imageKey) && (parentElement = context.getParentNodeName()) != null) {
                    index = parentElement.indexOf(":");
                    if (index != -1) {
                        parentElement = parentElement.substring(index + 1);
                    }
                    imageKey = parentElement + "/" + (String)imageKey;
                }
                iconPath = nameToIconPath.get(imageKey);
                renderingInfo.setIconPath(iconPath);
            } else if ("http://www.w3.org/2001/XMLSchema".equals(nodeNS)) {
                return this.xsdNodeRendererCustomizer.getRenderingInformation(context);
            }
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "XSLT Node Renderer Customizer";
    }

    static {
        nameToIconPath.put("message", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlMessage16.png"));
        nameToIconPath.put("part", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlMessagePart16.png"));
        nameToIconPath.put("portType", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlPortType16.png"));
        nameToIconPath.put("portType/operation", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlPortTypeOperation16.png"));
        nameToIconPath.put("binding", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlBinding16.png"));
        nameToIconPath.put("binding/operation", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlBindingOperation16.png"));
        nameToIconPath.put("service", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlService16.png"));
        nameToIconPath.put("port", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlServicePort16.png"));
        nameToIconPath.put("input", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlOperationInput16.png"));
        nameToIconPath.put("output", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlOperationOutput16.png"));
        nameToIconPath.put("fault", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlOperationFault16.png"));
        nameToIconPath.put("types", WSDLNodeRendererCustomizer.getImageURL("/images/node-customizer/wsdlTypesGroup16.png"));
    }
}

