/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.xerces.util.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.DocumentCreator;
import ro.sync.textsearch.dita.DITAShredderConfiguration;
import ro.sync.textsearch.dita.ReusableComponentShredder;
import ro.sync.textsearch.dita.noclass.DITANoClassShredderConfiguration;
import ro.sync.textsearch.docbook4.Docbook4ShredderConfiguration;
import ro.sync.textsearch.docbook5.Docbook5ShredderConfiguration;
import ro.sync.textsearch.heuristic.HeuristicShredderConfiguration;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.props.InputSourceWithProperties;
import ro.sync.textsearch.props.ResourceProperties;
import ro.sync.textsearch.webhelp.converter.IContentConverter;
import ro.sync.textsearch.webhelp.embeddings.IEmbeddingProvider;
import ro.sync.textsearch.xhtml.XHTMLShredderConfiguration;
import ro.sync.textsearch.xml.CompoundDefaultHandler;
import ro.sync.textsearch.xml.ElementsFilter;
import ro.sync.textsearch.xml.IShredder;
import ro.sync.textsearch.xml.ReviewShredder;
import ro.sync.textsearch.xml.XMLOptions;
import ro.sync.textsearch.xml.XMLReaderBundle;
import ro.sync.textsearch.xml.XMLShredder;
import ro.sync.textsearch.xml.XMLShredderConfiguration;
import ro.sync.textsearch.xml.XMLShredderConfigurationProvider;
import ro.sync.textsearch.xsd.XSDShredderConfiguration;
import ro.sync.textsearch.xsl.XSLShredderConfiguration;

public class XMLDocumentCreator
implements DocumentCreator {
    private static final Document[] EMPTY_ARRAY = new Document[0];
    private static final Logger logger = LoggerFactory.getLogger((String)XMLDocumentCreator.class.getName());
    private XMLReader parser;
    private Object grammarCache;
    private XMLOptions xmlOptions;
    protected XMLShredderConfigurationProvider shredderConfigurationProvider;
    private int maxDescLengthForTests = -1;
    private EntityResolver fakeEntityResolver;
    private final boolean isSkimmingMode;
    private final int xmlAwareContentSizeLimit;
    private final boolean allElementsToFields;

    public XMLDocumentCreator(XMLOptions xmlOptions) {
        this(xmlOptions, false, false, -1);
    }

    public XMLDocumentCreator(XMLOptions xmlOptions, boolean isSkimmingMode, boolean allElementsToFields, int xmlAwareContentSizeLimit) {
        this.isSkimmingMode = isSkimmingMode;
        this.allElementsToFields = allElementsToFields;
        this.xmlAwareContentSizeLimit = xmlAwareContentSizeLimit;
        this.shredderConfigurationProvider = new ConfigurationProvider();
        this.fakeEntityResolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource is = new InputSource(new StringReader(""));
                is.setSystemId(systemId);
                return is;
            }
        };
        this.setXMLOptions(xmlOptions);
    }

    protected void setXMLOptions(XMLOptions xmlOptions) {
        this.parser = xmlOptions.getXmlParserFactory().newXMLReader();
        this.grammarCache = null;
        this.xmlOptions = xmlOptions;
    }

    public final Document[] createDocuments(InputSource source) throws IOException, DocumentCreator.ParseException {
        return this.createDocuments(source, -1L, null, null, null, false);
    }

    @Override
    public Document[] createDocuments(InputSource source, long contentLenght, List<String> tagsAndClassesToIgnore, IContentConverter contentConverter, IEmbeddingProvider embeddingsProvider, boolean generateCompletionFields) throws IOException, DocumentCreator.ParseException {
        boolean isReusableTopic = this.isReusableTopic(source);
        boolean shouldSkim = !isReusableTopic && (this.isSkimmingMode || this.isOutsideXMLSizeLimit(contentLenght));
        logger.debug("Should Skim: {} {} xlimit {}", new Object[]{shouldSkim, contentLenght, this.xmlAwareContentSizeLimit});
        ArrayList<Document> ret = new ArrayList<Document>(2);
        try {
            ReusableComponentShredder reusableShredder;
            ReviewShredder reviewShredder;
            XMLShredder shredder;
            block11: {
                shredder = new XMLShredder(this.shredderConfigurationProvider, source.getSystemId(), shouldSkim);
                shredder.setGeneratesCompletionFields(generateCompletionFields);
                shredder.setAllElementsToFields(this.allElementsToFields);
                if (this.maxDescLengthForTests != -1) {
                    shredder.setMaxDescLengthForTests(this.maxDescLengthForTests);
                }
                reviewShredder = new ReviewShredder(this.getDescriptionMaxLength());
                CompoundDefaultHandler compoundHandler = new CompoundDefaultHandler(shredder, reviewShredder);
                reusableShredder = new ReusableComponentShredder();
                if (isReusableTopic) {
                    compoundHandler = new CompoundDefaultHandler(compoundHandler, reusableShredder);
                }
                XMLReader parser2use = this.createXMLParser(tagsAndClassesToIgnore, isReusableTopic, shredder, compoundHandler, null);
                try {
                    parser2use.parse(source);
                }
                catch (XMLShredder.SkimmingEndedException exk) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Stopped by skimming exception.");
                    }
                    if (!shouldSkim) {
                        throw exk;
                    }
                }
                catch (SAXException exk) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Stopped by sax exception.");
                    }
                    if (shouldSkim) break block11;
                    throw exk;
                }
            }
            Document doc = shredder.getLuceneDocument();
            ret.add(doc);
            if (!shouldSkim) {
                ret.addAll(reviewShredder.getLuceneDocuments());
                ret.addAll(reusableShredder.getLuceneDocuments());
            }
        }
        catch (SAXException e) {
            throw new DocumentCreator.ParseException(e);
        }
        return ret.toArray(EMPTY_ARRAY);
    }

    private boolean isOutsideXMLSizeLimit(long contentLenght) {
        return contentLenght > (long)this.xmlAwareContentSizeLimit && this.xmlAwareContentSizeLimit > -1;
    }

    private int getDescriptionMaxLength() {
        return this.maxDescLengthForTests != -1 ? this.maxDescLengthForTests : 256;
    }

    protected XMLReader createXMLParser(List<String> tagsAndClassesToIgnore, boolean isReusableTopic, IShredder shredder, ContentHandler compoundHandler, CompoundDefaultHandler compoundAdditionalHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        XMLReader parser2use;
        if (isReusableTopic) {
            XMLReaderBundle newXMLReaderWithGrammarCache = this.xmlOptions.getXmlParserFactory().newXMLReaderWithGrammarCache(this.grammarCache);
            this.grammarCache = newXMLReaderWithGrammarCache.getGrammarCache();
            parser2use = newXMLReaderWithGrammarCache.getXmlReader();
        } else {
            if (!this.xmlOptions.getReuseParser()) {
                this.parser = this.xmlOptions.getXmlParserFactory().newXMLReader();
            }
            if (this.xmlOptions.isDisableEntityResolver()) {
                this.parser.setEntityResolver(this.fakeEntityResolver);
            }
            parser2use = this.parser;
        }
        String securityManager = "http://apache.org/xml/properties/security-manager";
        if (parser2use.getProperty(securityManager) == null) {
            parser2use.setProperty(securityManager, new SecurityManager());
        }
        parser2use.setErrorHandler(new SilencedErrorHandler());
        DefaultHandler contentHandler = new ElementsFilter(compoundHandler, shredder, tagsAndClassesToIgnore);
        if (compoundAdditionalHandler != null) {
            contentHandler = new CompoundDefaultHandler(contentHandler, compoundAdditionalHandler);
        }
        parser2use.setContentHandler(contentHandler);
        parser2use.setProperty("http://xml.org/sax/properties/lexical-handler", shredder);
        return parser2use;
    }

    private boolean isReusableTopic(InputSource source) {
        ResourceProperties properties;
        boolean isReusableTopic = false;
        if (source instanceof InputSourceWithProperties && (properties = ((InputSourceWithProperties)source).getProperties()) != null) {
            isReusableTopic = properties.isReusableTopic();
        }
        return isReusableTopic;
    }

    public void setMaxDescLengthForTests(int maxDescLengthForTests) {
        this.maxDescLengthForTests = maxDescLengthForTests;
    }

    private static final class ConfigurationProvider
    implements XMLShredderConfigurationProvider {
        private XMLShredderConfiguration docbook5Config = new Docbook5ShredderConfiguration();
        private XMLShredderConfiguration docbook4Config = new Docbook4ShredderConfiguration();
        private XMLShredderConfiguration xslConfig = new XSLShredderConfiguration();
        private XMLShredderConfiguration xsdConfig = new XSDShredderConfiguration();
        private XMLShredderConfiguration htmlConfig = new XHTMLShredderConfiguration();
        private XMLShredderConfiguration ditaClassedConfig = new DITAShredderConfiguration();
        private XMLShredderConfiguration ditaNotClassedConfig = new DITANoClassShredderConfiguration();
        private XMLShredderConfiguration defaultConfig = new HeuristicShredderConfiguration();

        private ConfigurationProvider() {
        }

        @Override
        public XMLShredderConfiguration getConfiguration(Attributes rootAtts, String rootLocalName, String rootNamespace, String dtdPublicId, String dtdSystemId, String systemId) {
            if (logger.isDebugEnabled()) {
                logger.debug("Detecting configuration for: \nroot=" + rootLocalName + "\nrootAtts=" + this.dump(rootAtts) + "\nrootNamespace=" + rootNamespace + "\ndtdPublicId=" + TextSearchURIUtil.maskPasswords(dtdPublicId) + "\ndtdSystemId=" + TextSearchURIUtil.maskPasswords(dtdSystemId) + "\nsystemId=" + TextSearchURIUtil.maskPasswords(systemId));
            }
            XMLShredderConfiguration config = this.defaultConfig;
            if ("html".equals(rootLocalName) || "http://www.w3.org/1999/xhtml".equals(rootNamespace)) {
                config = this.htmlConfig;
            } else if ("http://www.w3.org/1999/XSL/Transform".equals(rootNamespace)) {
                config = this.xslConfig;
            } else if ("http://www.w3.org/2001/XMLSchema".equals(rootNamespace)) {
                config = this.xsdConfig;
            } else if ("http://docbook.org/ns/docbook".equals(rootNamespace)) {
                config = this.docbook5Config;
            } else if (dtdPublicId != null && dtdPublicId.contains("DTD DocBook XML") || dtdSystemId != null && dtdSystemId.contains("http://www.docbook.org")) {
                config = this.docbook4Config;
            } else if (rootAtts != null && rootAtts.getValue("ditaarch:DITAArchVersion") != null) {
                config = this.ditaClassedConfig;
            } else if (dtdPublicId != null && dtdPublicId.contains(" DITA ") || systemId != null && (systemId.endsWith(".dita") || systemId.endsWith(".ditamap"))) {
                config = this.ditaNotClassedConfig;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Using config: {}", (Object)config.getClass().getName());
            }
            return config;
        }

        private String dump(Attributes atts) {
            StringBuilder builder = new StringBuilder();
            if (atts != null) {
                int length = atts.getLength();
                for (int i = 0; i < length; ++i) {
                    builder.append(atts.getQName(i));
                    builder.append("=");
                    builder.append(atts.getValue(i));
                    builder.append(" ");
                }
            }
            return builder.toString();
        }
    }

    private final class SilencedErrorHandler
    implements ErrorHandler {
        private SilencedErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }
    }
}

