/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.io.Reader;

public abstract class IgnorableChunksFilterReader
extends Reader {
    private State state = State.NORMAL;
    int idx = 0;

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.isAfterEndOfString()) {
            return -1;
        }
        int rd = -1;
        while ((rd = this.readByIgnoringChunks(cbuf, off, len)) == 0) {
            if (!this.isAfterEndOfString()) continue;
            rd = -1;
            break;
        }
        return rd;
    }

    protected abstract boolean isAfterEndOfString();

    private int readByIgnoringChunks(char[] cbuf, int off, int len) {
        int endOffset = Math.min(this.idx + len, this.getStringLength());
        this.extractText(cbuf, off, endOffset);
        int read = endOffset - this.idx;
        int iw = 0;
        for (int i = 0; i < read; ++i) {
            char ch = cbuf[off + i];
            if (this.state == State.SKIPPING) {
                if (ch != '\u0000') continue;
                this.state = State.NORMAL;
                continue;
            }
            if (ch == '\u0000') {
                this.state = State.SKIPPING;
                continue;
            }
            if (iw != i) {
                cbuf[iw] = ch;
            }
            ++iw;
        }
        this.idx += read;
        return iw;
    }

    protected abstract int getStringLength();

    protected abstract void extractText(char[] var1, int var2, int var3);

    @Override
    public void close() {
    }

    @Override
    public int read() {
        char[] cb = new char[1];
        int rd = -1;
        while ((rd = this.read(cb, 0, 1)) == 0) {
        }
        if (rd == -1) {
            return -1;
        }
        return cb[0];
    }

    private static enum State {
        NORMAL,
        SKIPPING;

    }
}

