/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FilterRules {
    private List<String> tagsAndClassesToIgnore;

    public FilterRules(List<String> tagsAndClassesToIgnore) {
        this.tagsAndClassesToIgnore = tagsAndClassesToIgnore;
    }

    public boolean shouldIgnore(String tagName, String classAttrValue) {
        boolean shouldBeIgnored = false;
        if (this.tagsAndClassesToIgnore == null || this.tagsAndClassesToIgnore.isEmpty()) {
            return shouldBeIgnored;
        }
        List<String> classTokens = null;
        if (classAttrValue != null) {
            classTokens = this.tokenizeStringValue(classAttrValue);
        }
        for (String element : this.tagsAndClassesToIgnore) {
            int indexOf = element.indexOf(46);
            if (indexOf != -1) {
                String ignoreTagName = element.substring(0, indexOf);
                String ignoreClassAttrValue = element.substring(indexOf + 1);
                if (classTokens != null && !classTokens.isEmpty() && (ignoreTagName.isEmpty() || ignoreTagName.equals("*") || tagName.equals(ignoreTagName)) && classTokens.contains(ignoreClassAttrValue)) {
                    shouldBeIgnored = true;
                }
            } else if (tagName.equals(element)) {
                shouldBeIgnored = true;
            }
            if (!shouldBeIgnored) continue;
            break;
        }
        return shouldBeIgnored;
    }

    private List<String> tokenizeStringValue(String value) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }
}

