/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CompoundDefaultHandler
extends DefaultHandler {
    private List<DefaultHandler> delegates;

    public CompoundDefaultHandler(DefaultHandler ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.warning(exception);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.fatalError(exception);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        for (DefaultHandler delegate : this.delegates) {
            delegate.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.startElement(uri, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.skippedEntity(name);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.notationDecl(name, publicId, systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        for (DefaultHandler delegate : this.delegates) {
            delegate.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        DefaultHandler delegate;
        InputSource is = null;
        Iterator<DefaultHandler> iterator = this.delegates.iterator();
        while (iterator.hasNext() && (is = (delegate = iterator.next()).resolveEntity(publicId, systemId)) == null) {
        }
        return is;
    }
}

