/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xhtml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.xml.IShredder;

public class XHTMLBreadcrumbShredder
extends DefaultHandler
implements IShredder {
    private static final Logger logger = LoggerFactory.getLogger(XHTMLBreadcrumbShredder.class);
    private static final String HOME = "Home";
    private static final String JSON_OBJECT_TEMPLATE = "'{'\"title\": {0},\"relativePath\": \"{1}\"'}'";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Map<String, String> breadcrumbAccumulator = new LinkedHashMap<String, String>();
    private String currentDocumentTitle = "";
    private String currentDocumentPath = "";
    private String currentDocumentPathToRoot = "";
    private boolean shouldCollectCharacters = false;
    protected final Deque<State> statesStack = new LinkedList<State>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String classAttributeValue;
        String nameAttributeValue;
        if (logger.isDebugEnabled()) {
            logger.debug("Starting element localName {} # {} {}", new Object[]{localName, TextSearchURIUtil.maskPasswords(uri), qName});
        }
        if ("meta".equals(localName) && "wh-path2root".equals(nameAttributeValue = atts.getValue("name"))) {
            this.currentDocumentPathToRoot = atts.getValue("content");
        }
        State state = State.NOT_BREADCRUMB;
        if (this.statesStack.peekLast() == State.BREADCRUMB) {
            state = State.BREADCRUMB;
            if ("a".equals(localName)) {
                this.shouldCollectCharacters = true;
                this.currentDocumentPath = atts.getValue("href");
                if (this.currentDocumentPath == null) {
                    this.shouldCollectCharacters = false;
                }
            }
        } else if ("div".equals(localName) && "wh_breadcrumb".equals(classAttributeValue = atts.getValue("class"))) {
            state = State.BREADCRUMB;
        }
        this.statesStack.add(state);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.shouldCollectCharacters && this.statesStack.peekLast() == State.BREADCRUMB) {
            StringBuilder sb = new StringBuilder();
            sb.append(ch, start, length);
            if (!sb.toString().trim().isEmpty()) {
                this.currentDocumentTitle = this.currentDocumentTitle + sb.toString();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("a".equals(localName) && this.statesStack.peekLast() == State.BREADCRUMB) {
            if (this.currentDocumentPath == null) {
                return;
            }
            this.currentDocumentPath = this.currentDocumentPath.replace(this.currentDocumentPathToRoot, "");
            this.breadcrumbAccumulator.put(this.currentDocumentTitle, this.currentDocumentPath);
            this.currentDocumentTitle = "";
            this.currentDocumentPath = "";
            this.shouldCollectCharacters = false;
        }
        this.statesStack.removeLast();
    }

    public Field getDocumentField() {
        if (this.breadcrumbAccumulator.isEmpty()) {
            return new StoredField("__breadcrumb__", "[]");
        }
        String breadcrumbJSON = this.buildBreadcrumbJSON(this.breadcrumbAccumulator);
        return new StoredField("__breadcrumb__", breadcrumbJSON);
    }

    private String buildBreadcrumbJSON(Map<String, String> breadcrumbAccumulator) {
        return breadcrumbAccumulator.entrySet().stream().filter(entry -> !HOME.equals(entry.getKey())).map(entry -> {
            String breadCrumbTitle = this.toJSON((String)entry.getKey());
            return MessageFormat.format(JSON_OBJECT_TEMPLATE, breadCrumbTitle, entry.getValue());
        }).collect(Collectors.joining(",", "[", "]"));
    }

    private String toJSON(String key) {
        try {
            return MAPPER.writeValueAsString((Object)key);
        }
        catch (JsonProcessingException e) {
            logger.error("Could not write breadcrumb title to JSON: {}", (Object)key, (Object)e);
            return "";
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    private static enum State {
        BREADCRUMB,
        NOT_BREADCRUMB;

    }
}

