/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xhtml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.shredder.AbstractShredderBase;
import ro.sync.textsearch.xhtml.XHTMLElementStorageTypeProvider;
import ro.sync.textsearch.xml.ContentAccumulator;
import ro.sync.textsearch.xml.IgnorableChunksUtil;
import ro.sync.textsearch.xml.QName;
import ro.sync.textsearch.xml.XMLElementStorageProvider;
import ro.sync.textsearch.xml.XMLShredderConfiguration;

public class LightXHTMLShredder
extends AbstractShredderBase {
    private static final Logger logger = LoggerFactory.getLogger(LightXHTMLShredder.class);
    private boolean hadContent = false;
    private static final List<String> fencedElements = Collections.unmodifiableList(Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "div", "description", "title", "a"));

    public LightXHTMLShredder(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String nameAttributeValue;
        if (this.storageTypeProvider == null) {
            this.setConfiguration(new LightXHTMLShredderConfiguration());
        }
        logger.debug("Starting element {} # {} {}", new Object[]{localName, TextSearchURIUtil.maskPasswords(uri), qName});
        this.stIndexStack.push(this.rawContent.length());
        this.qNameStack.push(new QName(localName, uri));
        XMLElementStorageProvider.StorageType storageType = XMLElementStorageProvider.StorageType.DISCARD;
        if (this.storageTypeProvider != null) {
            storageType = this.storageTypeProvider.getStorageType(uri, localName, qName, atts);
        }
        boolean isMetaDescription = false;
        if ("meta".equals(localName) && "description".equals(nameAttributeValue = atts.getValue("name"))) {
            this.rawContent.append(atts.getValue("content"));
            isMetaDescription = true;
        }
        if (isMetaDescription) {
            this.storageStack.push(XMLElementStorageProvider.StorageType.STORE_AS_DESCRIPTION);
        } else {
            this.storageStack.push(storageType);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb = new StringBuilder();
        sb.append(ch, start, length);
        if (!sb.toString().trim().isEmpty()) {
            this.rawContent.append(sb.toString());
            this.hadContent = true;
            if (this.collectDescriptionFromText) {
                this.appendDescription(ch, start, length);
            }
        }
    }

    @Override
    protected void addSpaceBreak(StringBuilder rawContent) {
        super.addSpaceBreak(rawContent);
        if (this.collectDescriptionFromText && !this.isCollectedDescription()) {
            super.addSpaceBreak(this.longDesc);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.addSpaceBreak(this.rawContent);
        int stIndex = (Integer)this.stIndexStack.pop();
        int enIndex = this.rawContent.length();
        this.addEndOfTextMarker(localName);
        logger.debug("Ending element {}", (Object)qName);
        QName q = (QName)this.qNameStack.pop();
        XMLElementStorageProvider.StorageType storageType = (XMLElementStorageProvider.StorageType)((Object)this.storageStack.pop());
        if (stIndex < enIndex && !this.qNameStack.contains(q) && storageType != XMLElementStorageProvider.StorageType.DISCARD) {
            ContentAccumulator acc = this.elementsAccumulators.computeIfAbsent(q, k -> {
                ContentAccumulator a = new ContentAccumulator(this.rawContent);
                a.setStorageType(storageType);
                return a;
            });
            acc.add(stIndex, enIndex);
        }
    }

    private void addEndOfTextMarker(String localName) {
        if (fencedElements.contains(localName) && this.hadContent) {
            this.rawContent.append('\u0003');
            this.addSpaceBreak(this.rawContent);
            this.hadContent = false;
        }
    }

    @Override
    protected void setConfiguration(XMLShredderConfiguration config) {
        this.storageTypeProvider = config.getStorageTypeProvider();
        this.maxDescLength = config.getMaxDescLength();
        this.collectDescriptionFromText = config.isCollectDescriptionFromText();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.detectedDTDPublicId = publicId;
        this.detectedDTDSystemId = systemId;
    }

    public List<Field> getDocumentFields() {
        ArrayList<Field> documentFields = new ArrayList<Field>();
        String titleStr = null;
        String descStr = null;
        Set elems = this.elementsAccumulators.keySet();
        block5: for (QName qName : elems) {
            ContentAccumulator acc = (ContentAccumulator)this.elementsAccumulators.get(qName);
            if (acc.isEmpty()) continue;
            switch (acc.getStorageType()) {
                case BOOST_RELEVANT: {
                    documentFields.add((Field)new TextField(qName.getLocalName(), acc.createReader()));
                    continue block5;
                }
                case STORE_AS_TITLE: {
                    documentFields.add((Field)new TextField(qName.getLocalName(), acc.createReader()));
                    String title = acc.getFirstRangeContent();
                    if (title == null) continue block5;
                    titleStr = IgnorableChunksUtil.normalize(this.normalizer, title);
                    documentFields.addAll(this.getTextAndTermsFieldsForTitle(titleStr, false));
                    continue block5;
                }
                case STORE_AS_DESCRIPTION: {
                    String description = acc.getFirstRangeContent();
                    if (description == null) continue block5;
                    descStr = IgnorableChunksUtil.normalize(this.normalizer, description);
                    documentFields.add((Field)new StringField("__desc__", descStr, Field.Store.YES));
                    continue block5;
                }
            }
            logger.error("Should not get here. This is a programming error.");
        }
        if (descStr == null) {
            Optional.ofNullable(this.computeDescriptionField(titleStr)).ifPresent(documentFields::add);
        }
        documentFields.addAll(this.getTextAndTermsFields("text"));
        return documentFields;
    }

    @Override
    protected String processRawContentBeforeStore(String rawContent) {
        return rawContent.replace(String.valueOf('\u0003'), "");
    }

    @Override
    protected boolean generatesCompletionFields() {
        return true;
    }

    private class LightXHTMLShredderConfiguration
    extends XMLShredderConfiguration {
        public LightXHTMLShredderConfiguration() {
            this.setStorageTypeProvider(new LightXHTMLStorageTypeProvider());
        }
    }

    private class LightXHTMLStorageTypeProvider
    extends XHTMLElementStorageTypeProvider {
        public LightXHTMLStorageTypeProvider() {
            this.map.put("h1", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("h2", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("h3", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("h4", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("h5", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("h6", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("b", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("strong", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("em", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("i", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
            this.map.put("u", XMLElementStorageProvider.StorageType.BOOST_RELEVANT);
        }

        @Override
        public XMLElementStorageProvider.StorageType getStorageType(String uri, String localName, String qName, Attributes atts) {
            XMLElementStorageProvider.StorageType st = (XMLElementStorageProvider.StorageType)((Object)this.map.get(localName));
            if (st == null) {
                st = XMLElementStorageProvider.StorageType.DISCARD;
            }
            return st;
        }
    }
}

