/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.Compatibility;
import ro.sync.textsearch.ErrorHandler;
import ro.sync.textsearch.FacetsConfigurationFileNotFoundException;
import ro.sync.textsearch.IndexerEngine;
import ro.sync.textsearch.IndexingOptions;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.SearchResult;
import ro.sync.textsearch.TaxonomyIndexNotFoundException;
import ro.sync.textsearch.collectors.TopDocsAndTotalHits;
import ro.sync.textsearch.completion.CompletionEngineUtil;
import ro.sync.textsearch.completion.CompletionOptions;
import ro.sync.textsearch.completion.ScoredCompletion;
import ro.sync.textsearch.highlighter.HighlighterAndEncoder;
import ro.sync.textsearch.highlighter.WebHelpHighlighterAndEncoder;
import ro.sync.textsearch.props.ResourcePropertiesProvider;
import ro.sync.textsearch.webhelp.DocumentEmbeddingProcessor;
import ro.sync.textsearch.webhelp.KeywordsSuggestionsEngine;
import ro.sync.textsearch.webhelp.SearchSuggestion;
import ro.sync.textsearch.webhelp.SiteMapURLConnection;
import ro.sync.textsearch.webhelp.TitleSuggestionEngine;
import ro.sync.textsearch.webhelp.WebHelpQueryBuilder;
import ro.sync.textsearch.webhelp.WebHelpResourcesCollectorManager;
import ro.sync.textsearch.webhelp.converter.IContentConverter;
import ro.sync.textsearch.webhelp.embeddings.IEmbeddingProvider;
import ro.sync.textsearch.webhelp.faceting.FacetsConfigUtils;
import ro.sync.textsearch.xml.XMLOptions;

public class WebHelpIndexerEngine
extends IndexerEngine {
    private static final Logger logger = LoggerFactory.getLogger((String)WebHelpIndexerEngine.class.getName());
    private Map<URL, Long> siteMapResources;
    private static final String TAXONOMY_DEFAULT_DIR = "taxonomy";
    private File taxonomyDirFile = new File(INDEX_DIR, "taxonomy");
    private IEmbeddingProvider embeddingProvider;

    protected WebHelpIndexerEngine(File indexDirFile, Map<URL, Long> siteMapResources, List<String> tagsAndClassesToIgnore) {
        super(indexDirFile);
        this.siteMapResources = siteMapResources;
        this.tagsAndClassesToIgnore = tagsAndClassesToIgnore;
        this.taxonomyDirFile = new File(indexDirFile, TAXONOMY_DEFAULT_DIR);
    }

    public WebHelpIndexerEngine(File indexDirFile, XMLOptions xmlOptions, IndexingOptions indexingOptions, Map<URL, Long> siteMapResources, List<String> tagsAndClassesToIgnore, IEmbeddingProvider embeddingProvider) {
        super(indexDirFile, new Compatibility(indexDirFile), xmlOptions, indexingOptions, embeddingProvider);
        this.siteMapResources = siteMapResources;
        this.tagsAndClassesToIgnore = tagsAndClassesToIgnore;
        this.embeddingProvider = embeddingProvider;
        this.taxonomyDirFile = indexingOptions.getTaxonomyDirectoryFile();
    }

    public WebHelpIndexerEngine(File indexDirFile, XMLOptions xmlOptions, IndexingOptions indexingOptions, Map<URL, Long> siteMapResources, List<String> tagsAndClassesToIgnore, IEmbeddingProvider embeddingProvider, ReentrantReadWriteLock lock) {
        super(indexDirFile, xmlOptions, indexingOptions, lock, embeddingProvider);
        this.siteMapResources = siteMapResources;
        this.tagsAndClassesToIgnore = tagsAndClassesToIgnore;
        this.embeddingProvider = embeddingProvider;
        this.taxonomyDirFile = indexingOptions.getTaxonomyDirectoryFile();
    }

    public synchronized Map<IndexerEngine.IndexingResult, Integer> index(ResourcePropertiesProvider props, ErrorHandler errorHandler, IContentConverter contentConverter) throws IOException {
        return this.index(this.siteMapResources.keySet().iterator(), props, errorHandler, contentConverter);
    }

    public void filterFacets() {
        try {
            FacetsConfigUtils.filterFacets(this.taxonomyDirFile);
        }
        catch (TaxonomyIndexNotFoundException e) {
            logger.error("Taxonomy index was not found :", (Throwable)e);
        }
        catch (FacetsConfigurationFileNotFoundException e) {
            logger.error("JSON Facets Configuration was not found :", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult search(String text, SearchOptions searchOptions) throws ParseException, IOException {
        this.rwl.readLock().lock();
        try {
            SearchResult searchResult = this.executeSearch(text, searchOptions, true);
            return searchResult;
        }
        catch (IndexSearcher.TooManyClauses ex) {
            SearchResult searchResult = this.executeSearch(text, searchOptions, false);
            return searchResult;
        }
        finally {
            this.rwl.readLock().unlock();
            this.closeSearcher();
        }
    }

    private SearchResult executeSearch(String text, SearchOptions searchOptions, boolean wildcardScoring) throws ParseException, IOException {
        WebHelpQueryBuilder qb = new WebHelpQueryBuilder(text, this.searchingAnalyzer, searchOptions, wildcardScoring, this.embeddingProvider);
        Query searchQuery = qb.build();
        Query facetedQuery = qb.addFacets(searchQuery);
        SearchResult result = super.search(facetedQuery, qb.buildHighlightQuery(), qb.getTermMatchingPattern(), searchOptions);
        this.cleanupStaleDocuments(result);
        if (searchOptions.isHighlighting()) {
            this.addHighlightTokens(text, result);
        }
        if (this.taxonomyDirFile != null) {
            Map<String, Integer> facetsCount = this.obtainMatchingDocumentsFacetsCount(text, searchQuery, searchOptions);
            result.setFacetsToMatchingDocuments(facetsCount);
        }
        return result;
    }

    @Override
    protected CollectorManager<Collector, TopDocsAndTotalHits> createColector(SearchOptions searchOptions, IndexSearcher searcher) {
        return new WebHelpResourcesCollectorManager(searcher, searchOptions, this.createFacetsCollector());
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new SiteMapURLConnection(url, this.siteMapResources.get(url));
    }

    @Override
    protected void closeConnection(URLConnection connection) {
        if (connection instanceof SiteMapURLConnection) {
            ((SiteMapURLConnection)connection).disconnect();
        } else {
            super.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchSuggestion> getSearchSuggestions(String prefix, CompletionOptions completionOptions) throws IOException {
        this.rwl.readLock().lock();
        try {
            List<Object> suggestions;
            IndexSearcher indexSearcher = this.getSearcher();
            if (indexSearcher == null) {
                suggestions = Collections.emptyList();
            } else {
                if (prefix != null) {
                    prefix = prefix.toLowerCase();
                }
                TitleSuggestionEngine titleEngine = new TitleSuggestionEngine("__lc_title_completion_terms__", indexSearcher, this.searchingAnalyzer, this.indexingOptions.getStopWords());
                suggestions = titleEngine.getSuggestions(prefix, completionOptions);
                KeywordsSuggestionsEngine keywordsEngine = new KeywordsSuggestionsEngine(indexSearcher, this.searchingAnalyzer);
                suggestions.addAll(keywordsEngine.getCompletions(prefix, completionOptions));
            }
            List<SearchSuggestion> list = suggestions.stream().distinct().collect(Collectors.toList());
            return list;
        }
        finally {
            this.rwl.readLock().unlock();
            this.closeSearcher();
        }
    }

    @Override
    protected List<ScoredCompletion> filterCompletions(List<ScoredCompletion> completions, List<String> stopWords) {
        List<String> finalStopWords = stopWords != null ? stopWords : Arrays.asList(IndexerEngine.getStopWordsForLanguage("en"));
        return completions.stream().map(completion -> {
            this.removeStopWordsFromEnd((ScoredCompletion)completion, finalStopWords);
            return completion;
        }).distinct().filter(completion -> {
            boolean toReturn = true;
            if (completion.getTokens().length == 0) {
                toReturn = false;
            } else {
                for (String token : completion.getTokens()) {
                    if (!token.matches(".*?[0-9\\(\\)\\{\\}\\[\\]]")) continue;
                    toReturn = false;
                    break;
                }
            }
            return toReturn;
        }).collect(Collectors.toList());
    }

    @Override
    protected HighlighterAndEncoder getHighlighter(SearchOptions searchOptions) {
        return new WebHelpHighlighterAndEncoder(this.searchingAnalyzer, searchOptions);
    }

    @Override
    protected void addHighlightTokens(String text, SearchResult result) throws IOException {
        result.setCleanSearchQueryTokens(CompletionEngineUtil.tokenizeString(text, this.searchingAnalyzer, "text", true, Arrays.asList(WebHelpIndexerEngine.getStopWordsForLanguage(this.indexingOptions.getLang()))));
    }

    @Override
    protected Document addFacetsToDocumentAndTaxonomy(Document doc) {
        FacetsConfig facetsConfig = FacetsConfigUtils.getFacetsConfig(this.taxonomyDirFile);
        if (this.taxonomyDirFile != null) {
            List fields = doc.getFields();
            for (IndexableField field : fields) {
                Document document;
                if (!(field instanceof FacetField)) continue;
                DirectoryTaxonomyWriter taxonomyWriter = new DirectoryTaxonomyWriter((Directory)FSDirectory.open((Path)this.taxonomyDirFile.toPath()));
                try {
                    document = facetsConfig.build((TaxonomyWriter)taxonomyWriter, doc);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            taxonomyWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("The taxonomy index couldn't be read: ", (Throwable)e);
                    }
                }
                taxonomyWriter.close();
                return document;
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> obtainMatchingDocumentsFacetsCount(String text, Query searchQuery, SearchOptions searchOptions) throws IOException, ParseException {
        HashMap<String, Integer> facetsToMatchingDocuments = new HashMap<String, Integer>();
        this.rwl.readLock().lock();
        try {
            FacetsConfig facetsConfig = FacetsConfigUtils.getFacetsConfig(this.taxonomyDirFile);
            ArrayList<String> facetsToDisplay = new ArrayList<String>();
            Map dimConfigs = facetsConfig.getDimConfigs();
            for (Map.Entry dimConfig : dimConfigs.entrySet()) {
                facetsToDisplay.add((String)dimConfig.getKey());
            }
            String selectedFacets = searchOptions.getFacets();
            List<Object> selectedFacetsList = selectedFacets.isEmpty() ? new ArrayList() : Arrays.asList(selectedFacets.split(";"));
            HashMap<String, ArrayList<String>> categoryToSelectedFacets = new HashMap<String, ArrayList<String>>();
            for (String string : selectedFacetsList) {
                String categoty = string.split("/")[0];
                ArrayList<String> categoryFacets = (ArrayList<String>)categoryToSelectedFacets.get(categoty);
                if (categoryFacets == null) {
                    categoryFacets = new ArrayList<String>();
                    categoryFacets.add(string);
                    categoryToSelectedFacets.put(categoty, categoryFacets);
                    continue;
                }
                categoryFacets.add(string);
            }
            IndexSearcher searcher = this.getSearcher();
            WebHelpQueryBuilder webHelpQueryBuilder = new WebHelpQueryBuilder(text, this.searchingAnalyzer, searchOptions, true, this.embeddingProvider);
            for (String f : facetsToDisplay) {
                ArrayList<Object> facetsToCalculate = selectedFacetsList.isEmpty() ? new ArrayList() : new ArrayList<Object>(selectedFacetsList);
                List categoryFacets = (List)categoryToSelectedFacets.get(f);
                if (categoryFacets != null) {
                    facetsToCalculate.removeAll(categoryFacets);
                }
                Query q = webHelpQueryBuilder.addFacets(searchQuery, facetsToCalculate);
                FacetsCollector fc = (FacetsCollector)searcher.search(q, (CollectorManager)new FacetsCollectorManager());
                String[] taxonomyFiles = this.taxonomyDirFile.list();
                if (taxonomyFiles == null || taxonomyFiles.length <= 0) continue;
                FSDirectory taxonomyDir = FSDirectory.open((Path)this.taxonomyDirFile.toPath());
                try (DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader((Directory)taxonomyDir);){
                    FastTaxonomyFacetCounts taxonomyFacetCounts = new FastTaxonomyFacetCounts((TaxonomyReader)taxoReader, facetsConfig, fc);
                    FacetResult facetResult = taxonomyFacetCounts.getAllChildren(f, new String[0]);
                    if (facetResult == null) continue;
                    for (LabelAndValue facetLabelValue : facetResult.labelValues) {
                        facetsToMatchingDocuments.put(facetResult.dim + "/" + facetLabelValue.label, facetLabelValue.value.intValue());
                        Map<String, Integer> childsFacets = WebHelpIndexerEngine.getChildFacets(taxonomyFacetCounts, facetResult, facetLabelValue);
                        facetsToMatchingDocuments.putAll(childsFacets);
                    }
                }
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return facetsToMatchingDocuments;
    }

    private static Map<String, Integer> getChildFacets(FastTaxonomyFacetCounts taxonomyFacetCounts, FacetResult parentFacetResult, LabelAndValue parentFacetLabelValue) throws IOException {
        ArrayList<String> parentPathsList = new ArrayList<String>(parentFacetResult.path.length + 1);
        Collections.addAll(parentPathsList, parentFacetResult.path);
        parentPathsList.add(parentFacetLabelValue.label);
        CharSequence[] parentPathsArray = parentPathsList.toArray(new String[0]);
        HashMap<String, Integer> facetsToMatchingDocuments = new HashMap<String, Integer>();
        FacetResult childFacet = taxonomyFacetCounts.getAllChildren(parentFacetResult.dim, (String[])parentPathsArray);
        if (childFacet != null) {
            for (LabelAndValue childLabelValue : childFacet.labelValues) {
                String key = String.join((CharSequence)"/", parentPathsArray);
                facetsToMatchingDocuments.put(parentFacetResult.dim + "/" + key + "/" + childLabelValue.label, childLabelValue.value.intValue());
                Map<String, Integer> childsFacets = WebHelpIndexerEngine.getChildFacets(taxonomyFacetCounts, childFacet, childLabelValue);
                facetsToMatchingDocuments.putAll(childsFacets);
            }
        }
        return facetsToMatchingDocuments;
    }

    private void removeStopWordsFromEnd(ScoredCompletion completions, List<String> stopWords) {
        int finalLength = completions.getTokens().length;
        int i = completions.getTokens().length - 1;
        while (i >= 0 && stopWords.contains(completions.getTokens()[i])) {
            finalLength = i--;
        }
        completions.setTokens(Arrays.copyOf(completions.getTokens(), finalLength));
    }

    public void setSiteMapResources(Map<URL, Long> siteMapResources) {
        this.siteMapResources = siteMapResources;
    }

    @Override
    protected void postProcessDocuments(Document[] docs) {
        if (this.embeddingProvider != null && this.embeddingProvider.isSemanticSearchEnabled()) {
            DocumentEmbeddingProcessor embeddingsExtractor = new DocumentEmbeddingProcessor(this.embeddingProvider);
            embeddingsExtractor.computeEmbeddings(docs);
        }
    }

    private static String extractTitle(Document doc) {
        String title = doc.get("__xml_title__");
        return title;
    }

    private static String extractFileNameForDisplay(Document doc) {
        Object filename = new File(doc.get("__uri__")).getName();
        if (((String)filename).length() > 25) {
            filename = ((String)filename).substring(0, 22) + "...";
        }
        return filename;
    }

    static void display(Map<Integer, Document> list) throws IOException {
        logger.debug("");
        for (Document doc : list.values()) {
            String filename = WebHelpIndexerEngine.extractFileNameForDisplay(doc);
            String subjectLines = WebHelpIndexerEngine.extractTitle(doc);
            logger.debug("+------------------------------+------------------------------------------+");
            logger.debug(String.format("| %-28s | %-40s |", filename, subjectLines.toString().split("\n")[0]));
            for (int i = 1; i < subjectLines.toString().split("\n").length; ++i) {
                logger.debug(String.format("| %-28s | %-40s |", "", subjectLines.toString().split("\n")[i]));
            }
        }
        logger.debug("+------------------------------+------------------------------------------+");
        logger.debug("");
    }

    @Override
    protected boolean generatesCompletionFields() {
        return true;
    }

    @Override
    protected boolean createFacetsCollector() {
        return true;
    }
}

