/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.util;

public class Normalizer {
    private static final int NORMALIZE_STATE_TEXT = 1;
    private static final int NORMALIZE_STATE_WS = 2;
    private char[] buffer;
    private int cursor;

    public Normalizer() {
        this(256);
    }

    public Normalizer(int size) {
        this.buffer = new char[size];
    }

    public int normalizeArray(char[] ch, int start, int length, boolean removeWSAtStart) {
        int state = this.initializeState(removeWSAtStart);
        int end = start + length;
        for (int i = start; i < end; ++i) {
            state = this.append(ch[i], state);
        }
        return this.cursor;
    }

    public int normalizeString(String string, boolean removeWSAtStart, boolean removeWSAtEnd) {
        int state = this.initializeState(removeWSAtStart);
        int end = string.length();
        for (int i = 0; i < end; ++i) {
            state = this.append(string.charAt(i), state);
        }
        this.removeSpaceAtEnd(removeWSAtEnd);
        return this.cursor;
    }

    private final void removeSpaceAtEnd(boolean removeWSAtEnd) {
        if (removeWSAtEnd && this.cursor > 0 && this.isWhitespace(this.buffer[this.cursor - 1])) {
            --this.cursor;
        }
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    private int initializeState(boolean removeWSAtStart) {
        this.cursor = 0;
        int state = removeWSAtStart ? 2 : 1;
        return state;
    }

    private int append(char c, int state) {
        switch (state) {
            case 1: {
                if (this.isWhitespace(c)) {
                    state = 2;
                    this.buffer[this.cursor++] = 32;
                    break;
                }
                this.buffer[this.cursor++] = c;
                break;
            }
            case 2: {
                if (this.isWhitespace(c)) break;
                this.buffer[this.cursor++] = c;
                state = 1;
                break;
            }
        }
        if (this.cursor >= this.buffer.length) {
            this.reallocate();
        }
        return state;
    }

    private void reallocate() {
        int tmpLength = this.buffer.length;
        char[] buf = new char[this.buffer.length * 3 / 2 + 2];
        System.arraycopy(this.buffer, 0, buf, 0, tmpLength);
        this.buffer = buf;
    }

    private boolean isWhitespace(char ch) {
        if (ch <= ' ') {
            return true;
        }
        if (ch > ' ' && ch <= '\u007f') {
            return false;
        }
        return Character.isWhitespace(ch);
    }
}

