/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.dita;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.fields.StoredTextField;
import ro.sync.textsearch.fields.TextWithTermVectorsAndPositionsField;
import ro.sync.textsearch.util.Normalizer;
import ro.sync.textsearch.util.TrimUtil;

public class ReusableComponentShredder
extends DefaultHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)ReusableComponentShredder.class.getName());
    private Normalizer normalizer;
    private final Deque<ContextElement> contextStack = new LinkedList<ContextElement>();
    private final List<Document> documents = new ArrayList<Document>();

    private String extractDescription(String text) {
        if (this.normalizer == null) {
            this.normalizer = new Normalizer();
        }
        return TrimUtil.extractDescription(this.normalizer, text, 256);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String cls = attributes.getValue("class");
        boolean isTopic = cls != null && cls.contains(" topic/topic ");
        String id = attributes.getValue("id");
        Document doc = null;
        if (!isTopic && cls != null && id != null) {
            doc = new Document();
            this.documents.add(doc);
            doc.add((IndexableField)new StringField("__reusable__", "true", Field.Store.NO));
            doc.add((IndexableField)new StringField("__reusable_class__", cls, Field.Store.YES));
            doc.add((IndexableField)new StringField("__reusable_name__", qName, Field.Store.YES));
            String topicID = this.getParentTopicID();
            String path = topicID + "/" + id;
            doc.add((IndexableField)new TextField("__reusable_path__", path, Field.Store.YES));
            if (logger.isDebugEnabled()) {
                logger.debug("Reusable component: @class: " + cls + ", qname: " + qName + ", path " + path);
            }
        }
        this.addSpaceBreak();
        this.contextStack.push(new ContextElement(id, isTopic, doc));
    }

    private String getParentTopicID() {
        String topicID = null;
        for (ContextElement ce : this.contextStack) {
            if (!ce.isTopic) continue;
            topicID = ce.id;
            break;
        }
        return topicID;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ContextElement pop = this.contextStack.pop();
        UnderConstructionDocument ucd = pop.underConstructionDocument;
        if (ucd != null) {
            String stringValue;
            Document document = ucd.getDocument();
            IndexableField field = document.getField("__reusable_path__");
            String text = ucd.getText();
            StringBuilder rawText = new StringBuilder(text);
            if (field != null && (stringValue = field.stringValue()) != null && !stringValue.isEmpty()) {
                rawText.append(" ");
                rawText.append(stringValue);
            }
            String value = rawText.toString();
            document.add((IndexableField)new StoredTextField("__text__", value));
            document.add((IndexableField)new TextWithTermVectorsAndPositionsField("__completion_terms__", value));
            if (this.normalizer == null) {
                this.normalizer = new Normalizer();
            }
            document.add((IndexableField)new StringField("__reusable_description__", this.extractDescription(text), Field.Store.YES));
        }
        this.addSpaceBreak();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (ContextElement ce : this.contextStack) {
            if (ce.underConstructionDocument == null) continue;
            ce.underConstructionDocument.addText(ch, start, length);
        }
    }

    private void addSpaceBreak() {
        for (ContextElement ce : this.contextStack) {
            if (ce.underConstructionDocument == null) continue;
            ce.underConstructionDocument.addSpace();
        }
    }

    public List<Document> getLuceneDocuments() {
        return this.documents;
    }

    private static final class UnderConstructionDocument {
        private Document doc;
        private StringBuilder buff;

        public UnderConstructionDocument(Document doc) {
            this.doc = doc;
        }

        public void addText(char[] ch, int start, int length) {
            if (this.buff == null) {
                this.buff = new StringBuilder(length);
            }
            this.buff.append(ch, start, length);
        }

        public void addSpace() {
            if (this.buff == null) {
                this.buff = new StringBuilder();
            }
            if (this.buff.length() > 0 && this.buff.charAt(this.buff.length() - 1) != ' ') {
                this.buff.append(' ');
            }
        }

        public Document getDocument() {
            return this.doc;
        }

        public String getText() {
            String txt = this.buff == null ? "" : this.buff.toString();
            return txt;
        }
    }

    private static final class ContextElement {
        private String id;
        private boolean isTopic;
        private UnderConstructionDocument underConstructionDocument;

        public ContextElement(String id, boolean isTopic, Document doc) {
            this.id = id;
            this.isTopic = isTopic;
            if (doc != null) {
                this.underConstructionDocument = new UnderConstructionDocument(doc);
            }
        }
    }
}

