/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion.trie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ro.sync.textsearch.completion.trie.SimilarityTrieNode;

class EndCompletionsNodes {
    private int maximumCompletionsWithSameLength;
    private HashMap<Integer, List<SimilarityTrieNode>> lastNodesMap = new HashMap();

    public EndCompletionsNodes(int maximumCompletionsWithSameLength) {
        this.maximumCompletionsWithSameLength = maximumCompletionsWithSameLength;
    }

    public void addNode(SimilarityTrieNode node, int len) {
        List list = this.lastNodesMap.computeIfAbsent(len, k -> new ArrayList());
        list.add(node);
        list.sort((o1, o2) -> o1.getScore() > o2.getScore() ? -1 : 1);
        if (list.size() > this.maximumCompletionsWithSameLength) {
            list.remove(list.size() - 1);
        }
    }

    public List<SimilarityTrieNode> getAllNodes() {
        ArrayList<SimilarityTrieNode> result = new ArrayList<SimilarityTrieNode>();
        for (List<SimilarityTrieNode> list : this.lastNodesMap.values()) {
            result.addAll(list);
        }
        return result;
    }
}

