/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.Completion;
import ro.sync.textsearch.completion.CompletionDumper;
import ro.sync.textsearch.completion.CompletionEngineUtil;
import ro.sync.textsearch.completion.CompletionExtractor;
import ro.sync.textsearch.completion.CompletionExtractorUsingAccumulators;
import ro.sync.textsearch.completion.CompletionExtractorUsingStringArray;
import ro.sync.textsearch.completion.CompletionOptions;
import ro.sync.textsearch.completion.ScoredCompletion;
import ro.sync.textsearch.completion.SpanPositionsCollectorManager;
import ro.sync.textsearch.completion.trie.SimilarityTrie;

public class PhraseCompletionEngine {
    private static final Logger logger = LoggerFactory.getLogger(PhraseCompletionEngine.class);
    protected IndexSearcher searcher;
    protected Analyzer searchingAnalyzer;
    private String searchFieldName;

    public PhraseCompletionEngine(String searchFieldName, IndexSearcher searcher, Analyzer searchingAnalyzer) {
        this.searchFieldName = searchFieldName;
        this.searcher = searcher;
        this.searchingAnalyzer = searchingAnalyzer;
    }

    public static List<String> getPrefixTokens(String prefix, Analyzer analyzer, CompletionOptions completionOptions) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        if (prefix != null) {
            List<String> tokens = CompletionEngineUtil.tokenizeString(prefix, analyzer);
            int count = 0;
            for (int i = tokens.size() - 1; i >= 0; --i) {
                String tk = tokens.get(i);
                result.addFirst(tk);
                if (count >= completionOptions.getMaximumPrefixSize()) break;
            }
        }
        return result;
    }

    public List<ScoredCompletion> getCompletions(String prefix, CompletionOptions completionOptions) throws IOException {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        List<String> prefixTokens = PhraseCompletionEngine.getPrefixTokens(prefix, this.searchingAnalyzer, completionOptions);
        while (prefixTokens.size() >= completionOptions.getMinimumPrefixSize()) {
            logger.debug("Prefix {} - size in words: {}", prefixTokens, (Object)prefixTokens.size());
            CompletionExtractor completionExtractor = this.getCompletionExtractor(completionOptions, prefixTokens.size());
            List<Completion> partialCompletions = this.getCompletions(prefixTokens, completionExtractor, completionOptions);
            completions.addAll(partialCompletions);
            if (!completions.isEmpty()) break;
            CompletionDumper.dumpCompletions(logger, " Got partial results: ", partialCompletions);
            prefixTokens.remove(0);
        }
        List<ScoredCompletion> scoredCompletions = completionOptions.isUseTrie() ? this.applyTrie(completions, completionOptions) : this.getDummyScoredCompletions(completions, completionOptions.getMaximumNumberOfCompletions());
        CompletionDumper.dumpCompletions(logger, "Scored completions", scoredCompletions);
        return scoredCompletions;
    }

    private CompletionExtractor getCompletionExtractor(CompletionOptions completionOptions, int prefixSize) {
        int size = prefixSize * 2;
        int maximumCompletionSize = completionOptions.getMaximumCompletionSize();
        if (size > maximumCompletionSize) {
            size = maximumCompletionSize;
        }
        logger.debug("Using completion size: {}", (Object)size);
        CompletionExtractor completionExtractor = completionOptions.isUseAccumulators() ? new CompletionExtractorUsingAccumulators(this.searchFieldName, this.searcher, size) : new CompletionExtractorUsingStringArray(this.searchFieldName, this.searcher, size);
        return completionExtractor;
    }

    private List<ScoredCompletion> getDummyScoredCompletions(List<Completion> completions, int maximumNumberOfCompletions) {
        int size = Math.min(completions.size(), maximumNumberOfCompletions);
        ArrayList<ScoredCompletion> scoredCompletions = new ArrayList<ScoredCompletion>(size);
        for (int i = 0; i < size; ++i) {
            scoredCompletions.add(new ScoredCompletion(0.0f, completions.get(i).getTokens()));
        }
        return scoredCompletions;
    }

    private List<Completion> getCompletions(List<String> prefixTokens, CompletionExtractor completionExtractor, CompletionOptions completionOptions) throws IOException {
        SpanQuery query;
        ArrayList<Completion> completions = new ArrayList<Completion>();
        if (prefixTokens != null && (query = this.getSpanNearQuery(prefixTokens, completionOptions)) != null) {
            logger.debug("Query {}", (Object)query);
            LinkedHashMap docIdsToSpans = (LinkedHashMap)this.searcher.search((Query)query, (CollectorManager)new SpanPositionsCollectorManager());
            logger.debug("Found {} documents.", (Object)docIdsToSpans.size());
            Set entries = docIdsToSpans.entrySet();
            for (Map.Entry docIdToSpans : entries) {
                completions.addAll(completionExtractor.getCompletionsFromDocument((Integer)docIdToSpans.getKey(), (List)docIdToSpans.getValue()));
            }
        }
        return completions;
    }

    public List<ScoredCompletion> applyTrie(List<Completion> completions, CompletionOptions completionOptions) {
        SimilarityTrie trie = new SimilarityTrie(completions, completionOptions);
        return trie.computeBestCompletions();
    }

    private SpanQuery getSpanNearQuery(List<String> prefixTokens, CompletionOptions completionOptions) {
        Object spanQuery = null;
        int size = prefixTokens.size();
        if (size >= completionOptions.getMinimumPrefixSize()) {
            ArrayList<SpanTermQuery> sqs = new ArrayList<SpanTermQuery>();
            for (int i = 0; i < size; ++i) {
                sqs.add(new SpanTermQuery(new Term(this.searchFieldName, prefixTokens.get(i))));
            }
            spanQuery = sqs.size() == 1 ? (SpanQuery)sqs.get(0) : new SpanNearQuery(sqs.toArray(new SpanQuery[sqs.size()]), 0, true);
        }
        return spanQuery;
    }
}

