/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;

public class ContentReconstructor {
    private IndexSearcher searcher;
    private String searchFieldName;

    public ContentReconstructor(String searchFieldName, IndexSearcher searcher) {
        this.searcher = searcher;
        this.searchFieldName = searchFieldName;
    }

    public String[] reconstructDocument(int docId) throws IOException {
        String[] docTokens = null;
        TermVectors termVectors = this.searcher.getIndexReader().termVectors();
        Terms termVector = termVectors.get(docId, this.searchFieldName);
        if (termVector != null) {
            int docSize = ContentReconstructor.getDocSize(termVector);
            docTokens = this.reconstructDocument(termVector, docSize);
        }
        return docTokens;
    }

    protected static int getDocSize(Terms termVector) throws IOException {
        int count = 0;
        PostingsEnum postingsEnum = null;
        TermsEnum iterator = termVector.iterator();
        while (iterator.next() != null) {
            postingsEnum = iterator.postings(postingsEnum, 120);
            postingsEnum.nextDoc();
            count += postingsEnum.freq();
        }
        return count;
    }

    private String[] reconstructDocument(Terms termVector, int docSize) throws IOException {
        BytesRef bytesRef;
        String[] reconstructedContent = new String[docSize];
        PostingsEnum postingsEnum = null;
        TermsEnum iterator = termVector.iterator();
        while ((bytesRef = iterator.next()) != null) {
            String termString = bytesRef.utf8ToString();
            postingsEnum = iterator.postings(postingsEnum, 120);
            this.reconstructDocumentFromTerm(reconstructedContent, postingsEnum, termString);
        }
        return reconstructedContent;
    }

    private void reconstructDocumentFromTerm(String[] docContent, PostingsEnum postingsEnum, String termString) throws IOException {
        postingsEnum.nextDoc();
        int fr = postingsEnum.freq();
        ArrayList<Integer> allPositions = new ArrayList<Integer>();
        for (int j = 0; j < fr; ++j) {
            int p = postingsEnum.nextPosition();
            docContent[p] = termString;
            allPositions.add(p);
        }
    }
}

