/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.collectors;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollector;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.collectors.SelectedResourcesCollector;
import ro.sync.textsearch.collectors.TopDocsAndTotalHits;

public class SelectedResourcesCollectorManager
implements CollectorManager<Collector, TopDocsAndTotalHits> {
    private final boolean createFacetsCollector;
    private SearchOptions searchOptions;
    private IndexSearcher searcher;

    public SelectedResourcesCollectorManager(IndexSearcher searcher, SearchOptions searchOptions, boolean createFacetsCollector) {
        this.searcher = searcher;
        this.searchOptions = searchOptions;
        this.createFacetsCollector = createFacetsCollector;
    }

    public Collector newCollector() throws IOException {
        TopScoreDocCollector docsCollector = new TopScoreDocCollectorManager(this.searchOptions.getMaximumHitsNumber(), null, 0, false).newCollector();
        TotalHitCountCollector hitsCollector = new TotalHitCountCollector();
        SelectedResourcesCollector selectedFilesCollector = new SelectedResourcesCollector((Collector)docsCollector, hitsCollector, this.searcher, this.searchOptions.getSelectedResources());
        if (this.createFacetsCollector) {
            return MultiCollector.wrap((Collector[])new Collector[]{selectedFilesCollector, new FacetsCollector()});
        }
        return selectedFilesCollector;
    }

    public TopDocsAndTotalHits reduce(Collection<Collector> collectors) throws IOException {
        TopDocs[] topDocs = new TopDocs[collectors.size()];
        int i = 0;
        int totalHits = 0;
        for (Collector collector : collectors) {
            if (collector instanceof MultiCollector) {
                collector = ((MultiCollector)collector).getCollectors()[0];
            }
            if (!(collector instanceof SelectedResourcesCollector)) continue;
            SelectedResourcesCollector resCollector = (SelectedResourcesCollector)collector;
            TopScoreDocCollector docsCollector = (TopScoreDocCollector)resCollector.getInnerCollector();
            topDocs[i++] = docsCollector.topDocs();
            totalHits += resCollector.getTotalHits();
        }
        return new TopDocsAndTotalHits(TopDocs.merge((int)0, (int)this.searchOptions.getMaximumHitsNumber(), (TopDocs[])topDocs), totalHits);
    }
}

