/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.collectors;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.TotalHitCountCollector;

public class SelectedResourcesCollector
extends FilterCollector {
    private IndexSearcher searcher;
    private HashSet<String> selectedResources = new HashSet();
    private TotalHitCountCollector hitsCollector;

    public SelectedResourcesCollector(Collector in, TotalHitCountCollector hitsCollector, IndexSearcher searcher, List<String> selectedResources) {
        super(in);
        this.hitsCollector = hitsCollector;
        this.searcher = searcher;
        this.selectedResources.addAll(selectedResources);
    }

    public int getTotalHits() {
        return this.hitsCollector.getTotalHits();
    }

    public Collector getInnerCollector() {
        return this.in;
    }

    public LeafCollector getLeafCollector(final LeafReaderContext context) throws IOException {
        return new FilterLeafCollector(super.getLeafCollector(context)){

            public void collect(int docId) throws IOException {
                if (!SelectedResourcesCollector.this.selectedResources.isEmpty()) {
                    String decodedURI;
                    String uri = SelectedResourcesCollector.this.searcher.storedFields().document(docId).get("__uri__");
                    if (uri != null && SelectedResourcesCollector.this.selectedResources.contains(decodedURI = URLDecoder.decode(uri, StandardCharsets.UTF_8.toString()))) {
                        this.in.collect(docId);
                        if (SelectedResourcesCollector.this.hitsCollector != null) {
                            SelectedResourcesCollector.this.hitsCollector.getLeafCollector(context).collect(docId);
                        }
                    }
                } else {
                    this.in.collect(docId);
                    if (SelectedResourcesCollector.this.hitsCollector != null) {
                        SelectedResourcesCollector.this.hitsCollector.getLeafCollector(context).collect(docId);
                    }
                }
            }
        };
    }
}

