/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import ro.sync.textsearch.FieldConstants;
import ro.sync.textsearch.OxygenKnnFloatVectorQuery;
import ro.sync.textsearch.scoring.FieldBoostProvider;
import ro.sync.textsearch.webhelp.embeddings.IEmbedding;
import ro.sync.textsearch.webhelp.embeddings.IEmbeddingProvider;

public class SemanticSearchQueryBuilder {
    private static final int TOP_DOCS_NUMBER = 20;
    private String searchText;
    private IEmbeddingProvider embeddingsProvider;

    public SemanticSearchQueryBuilder(String searchText, IEmbeddingProvider embeddingsProvider) {
        this.searchText = searchText;
        this.embeddingsProvider = embeddingsProvider;
    }

    public Query build() {
        float[] searchTextEmbedding;
        IEmbedding searchQueryEmbeddings;
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        if (this.embeddingsProvider != null && this.embeddingsProvider.isSemanticSearchEnabled() && (searchQueryEmbeddings = this.embeddingsProvider.createEmbeddings(this.searchText)) != null && (searchTextEmbedding = searchQueryEmbeddings.getVector()) != null) {
            Map<String, Float> boosts = FieldBoostProvider.getEmbeddingFieldsScoring();
            FieldConstants.EMBEDDING_FIELDS.forEach(field -> {
                OxygenKnnFloatVectorQuery query = new OxygenKnnFloatVectorQuery((String)field, searchTextEmbedding, 20, this.embeddingsProvider.getSemanticSearchSimilarityThreshold());
                queryBuilder.add((Query)new BoostQuery((Query)query, ((Float)boosts.get(field)).floatValue()), BooleanClause.Occur.SHOULD);
            });
        }
        return queryBuilder.build();
    }
}

