/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangToAnalyzer {
    private final HashMap<String, String> langToAnalyzer = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger((String)LangToAnalyzer.class.getName());

    public LangToAnalyzer() {
        this.langToAnalyzer.put("ar", "org.apache.lucene.analysis.ar.ArabicAnalyzer");
        this.langToAnalyzer.put("bg", "org.apache.lucene.analysis.bg.BulgarianAnalyzer");
        this.langToAnalyzer.put("br", "org.apache.lucene.analysis.br.BrazilianAnalyzer");
        this.langToAnalyzer.put("ca", "org.apache.lucene.analysis.ca.CatalanAnalyzer");
        this.langToAnalyzer.put("cs", "org.apache.lucene.analysis.cz.CzechAnalyzer");
        this.langToAnalyzer.put("da", "org.apache.lucene.analysis.da.DanishAnalyzer");
        this.langToAnalyzer.put("de", "org.apache.lucene.analysis.de.GermanAnalyzer");
        this.langToAnalyzer.put("el", "org.apache.lucene.analysis.el.GreekAnalyzer");
        this.langToAnalyzer.put("en", "org.apache.lucene.analysis.en.EnglishAnalyzer");
        this.langToAnalyzer.put("es", "org.apache.lucene.analysis.es.SpanishAnalyzer");
        this.langToAnalyzer.put("fa", "org.apache.lucene.analysis.fa.PersianAnalyzer");
        this.langToAnalyzer.put("fi", "org.apache.lucene.analysis.fi.FinnishAnalyzer");
        this.langToAnalyzer.put("fr", "org.apache.lucene.analysis.fr.FrenchAnalyzer");
        this.langToAnalyzer.put("ga", "org.apache.lucene.analysis.ga.IrishAnalyzer");
        this.langToAnalyzer.put("gl", "org.apache.lucene.analysis.gl.GalicianAnalyzer");
        this.langToAnalyzer.put("hi", "org.apache.lucene.analysis.hi.HindiAnalyzer");
        this.langToAnalyzer.put("hu", "org.apache.lucene.analysis.hu.HungarianAnalyzer");
        this.langToAnalyzer.put("hy", "org.apache.lucene.analysis.hy.ArmenianAnalyzer");
        this.langToAnalyzer.put("id", "org.apache.lucene.analysis.id.IndonesianAnalyzer");
        this.langToAnalyzer.put("it", "org.apache.lucene.analysis.it.ItalianAnalyzer");
        this.langToAnalyzer.put("lv", "org.apache.lucene.analysis.lv.LatvianAnalyzer");
        this.langToAnalyzer.put("nl", "org.apache.lucene.analysis.nl.DutchAnalyzer");
        this.langToAnalyzer.put("no", "org.apache.lucene.analysis.no.NorwegianAnalyzer");
        this.langToAnalyzer.put("pt", "org.apache.lucene.analysis.pt.PortugueseAnalyzer");
        this.langToAnalyzer.put("ro", "org.apache.lucene.analysis.ro.RomanianAnalyzer");
        this.langToAnalyzer.put("ru", "org.apache.lucene.analysis.ru.RussianAnalyzer");
        this.langToAnalyzer.put("sw", "org.apache.lucene.analysis.sv.SwedishAnalyzer");
        this.langToAnalyzer.put("th", "org.apache.lucene.analysis.th.ThaiAnalyzer");
        this.langToAnalyzer.put("tr", "org.apache.lucene.analysis.tr.TurkishAnalyzer");
        this.langToAnalyzer.put("ko", "org.apache.lucene.analysis.cjk.CJKAnalyzer");
        this.langToAnalyzer.put("zh", "org.apache.lucene.analysis.cjk.CJKAnalyzer");
        this.langToAnalyzer.put("ja", "ro.sync.textsearch.analyzer.JapaneseAnalyzer");
    }

    public Analyzer buildAnalyzer(String lang, List<String> stopWords) {
        Analyzer analyzer = null;
        try {
            String className = this.langToAnalyzer.get(lang);
            if (className != null) {
                Class<?> forName = Class.forName(className);
                if (stopWords != null) {
                    try {
                        analyzer = (Analyzer)forName.getConstructor(CharArraySet.class).newInstance(new CharArraySet(stopWords, true));
                    }
                    catch (Throwable th) {
                        logger.warn("Cannot set stopwords to the analyzer of class " + forName + ". Leaving the default.", th);
                        analyzer = (Analyzer)forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                } else {
                    try {
                        analyzer = (Analyzer)forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable th) {
                        logger.warn("Cannot build using the version only constructor of class " + forName + ". Leaving the default.", th);
                        analyzer = (Analyzer)forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("No analyzer class mapping for language: " + lang);
            }
        }
        catch (Throwable e) {
            logger.error("Cannot load analyzer due to: " + e, e);
        }
        return analyzer;
    }

    public String[] getSupportedLanguages() {
        return new TreeSet<String>(this.langToAnalyzer.keySet()).toArray(new String[0]);
    }
}

