/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.facet.FacetsConfig;
import ro.sync.textsearch.util.TextSearchEqualer;

public class IndexingOptions
implements Serializable {
    private static final long serialVersionUID = 8474113063753517421L;
    private final boolean indexContent;
    private final boolean indexRemoteContent;
    private final String ignorePatterns;
    private final HashMap<String, String> extToCTMap;
    private final boolean xmlAware;
    private String encodingForNonXMLFiles;
    private final boolean allElementsToFields;
    private List<String> stopWords;
    private String lang;
    private transient FacetsConfig facetsConfig;
    private File taxonomyDirFile;
    private int xmlAwareContentSizeLimit;

    public IndexingOptions(String lang, boolean indexContent, boolean indexRemoteContent, String ignorePatterns, HashMap<String, String> extToCTMap, boolean xmlAware, String encodingForNonXMLFiles, int xmlAwareContentSizeLimit, boolean allElementsToFields, List<String> stopWords) {
        this.lang = lang;
        this.indexContent = indexContent;
        this.indexRemoteContent = indexRemoteContent;
        this.ignorePatterns = ignorePatterns;
        this.extToCTMap = extToCTMap;
        this.xmlAware = xmlAware;
        this.encodingForNonXMLFiles = encodingForNonXMLFiles;
        this.xmlAwareContentSizeLimit = xmlAwareContentSizeLimit;
        this.allElementsToFields = allElementsToFields;
        this.stopWords = stopWords;
    }

    public IndexingOptions(boolean indexContent, boolean indexRemoteContent, String ignorePatterns, HashMap<String, String> extToCTMap) {
        this(null, indexContent, indexRemoteContent, ignorePatterns, extToCTMap, true, "UTF-8", -1, false, null);
    }

    public boolean isIndexingContent() {
        return this.indexContent;
    }

    public boolean isIndexingRemoteContent() {
        return this.indexRemoteContent;
    }

    public boolean equals(Object obj) {
        boolean eq = false;
        if (obj instanceof IndexingOptions) {
            IndexingOptions other = (IndexingOptions)obj;
            try {
                eq = this.indexContent == other.indexContent && this.indexRemoteContent == other.indexRemoteContent && TextSearchEqualer.verifyEquals(this.ignorePatterns, other.ignorePatterns) && TextSearchEqualer.verifyEquals(this.extToCTMap, other.extToCTMap) && this.xmlAware == other.xmlAware && TextSearchEqualer.verifyEquals(this.encodingForNonXMLFiles, other.encodingForNonXMLFiles) && this.xmlAwareContentSizeLimit == other.xmlAwareContentSizeLimit && this.allElementsToFields == other.allElementsToFields && TextSearchEqualer.verifyEquals(this.lang, other.lang) && TextSearchEqualer.verifyEquals(this.stopWords, other.stopWords);
            }
            catch (Exception ex) {
                eq = false;
            }
        }
        return eq;
    }

    public String getIgnorePatterns() {
        return this.ignorePatterns;
    }

    public HashMap<String, String> getExtToCT() {
        return this.extToCTMap;
    }

    public boolean isXmlAware() {
        return this.xmlAware;
    }

    public int getXmlAwareContentSizeLimit() {
        return this.xmlAwareContentSizeLimit;
    }

    public boolean bindAllElementsToFields() {
        return this.allElementsToFields;
    }

    public List<String> getStopWords() {
        return this.stopWords;
    }

    public String getLang() {
        return this.lang;
    }

    public File getTaxonomyDirectoryFile() {
        return this.taxonomyDirFile;
    }

    public void setTaxonomyDirectoryFile(File taxonomyDirFile) {
        this.taxonomyDirFile = taxonomyDirFile;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("lang = " + this.lang + "\n");
        buff.append("extToCTMap = " + this.extToCTMap + "\n");
        buff.append("ignorePatterns = " + this.ignorePatterns + "\n");
        buff.append("indexContent = " + this.indexContent + "\n");
        buff.append("indexRemoteContent = " + this.indexRemoteContent + "\n");
        buff.append("xmlAware = " + this.xmlAware + "\n");
        buff.append("allElementsToFields = " + this.allElementsToFields + "\n");
        buff.append("stopWords = " + this.stopWords + "\n");
        return buff.toString();
    }

    public String getEncodingForNonXMLFiles() {
        return this.encodingForNonXMLFiles;
    }

    public FacetsConfig getFacetsConfig() {
        return this.facetsConfig;
    }

    public void setFacetsConfig(FacetsConfig facetsConfig) {
        this.facetsConfig = facetsConfig;
    }

    public int hashCode() {
        return 55;
    }
}

