/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.common.IImageMetadata;

public class ImageMetadata
implements IImageMetadata {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final List<IImageMetadata.IImageMetadataItem> items = new ArrayList<IImageMetadata.IImageMetadataItem>();

    public void add(String keyword, String text) {
        this.add(new Item(keyword, text));
    }

    public void add(IImageMetadata.IImageMetadataItem item) {
        this.items.add(item);
    }

    @Override
    public List<? extends IImageMetadata.IImageMetadataItem> getItems() {
        return new ArrayList<IImageMetadata.IImageMetadataItem>(this.items);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String prefix) {
        if (null == prefix) {
            prefix = "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.items.size(); ++i) {
            if (i > 0) {
                result.append(NEWLINE);
            }
            IImageMetadata.IImageMetadataItem item = this.items.get(i);
            result.append(item.toString(prefix + "\t"));
        }
        return result.toString();
    }

    public static class Item
    implements IImageMetadata.IImageMetadataItem {
        private final String keyword;
        private final String text;

        public Item(String keyword, String text) {
            this.keyword = keyword;
            this.text = text;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public String toString() {
            return this.toString(null);
        }

        @Override
        public String toString(String prefix) {
            String result = this.keyword + ": " + this.text;
            if (null != prefix) {
                return prefix + result;
            }
            return result;
        }
    }
}

