/*
 * Decompiled with CFR 0.152.
 */
package com.martinprobst.xqpretty;

import com.martinprobst.xqpretty.XQToken;
import java.util.ArrayList;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class LazyTokenStream
implements TokenStream {
    private final ArrayList<XQToken> tokens = new ArrayList();
    private int offset;
    private int lastMarker;
    private TokenSource source;
    protected int range = -1;

    public LazyTokenStream(TokenSource source) {
        this.source = source;
    }

    private boolean assertSize(int size) {
        if (size < this.tokens.size()) {
            return true;
        }
        int current = this.tokens.size();
        XQToken hiddenToken = null;
        while (current < size) {
            Token t = this.source.nextToken();
            if (t == Token.EOF_TOKEN) {
                return false;
            }
            XQToken xqt = (XQToken)t;
            xqt.setHiddenPredecessor(hiddenToken);
            if (xqt.getType() == -1) {
                return false;
            }
            if (xqt.getChannel() == 99) {
                hiddenToken = xqt;
                continue;
            }
            xqt.setTokenIndex(current);
            ++current;
            this.tokens.add(xqt);
        }
        return true;
    }

    public void consume() {
        ++this.offset;
    }

    public Token LT(int k) {
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            if (this.offset + k < 0) {
                return null;
            }
            if (!this.assertSize(this.offset + k + 1)) {
                return Token.EOF_TOKEN;
            }
            return (Token)this.tokens.get(this.offset + k);
        }
        if (!this.assertSize(this.offset + k)) {
            return Token.EOF_TOKEN;
        }
        if (k > this.range) {
            this.range = k;
        }
        return (Token)this.tokens.get(this.offset + k - 1);
    }

    public Token get(int i) {
        if (!this.assertSize(i + 1)) {
            return Token.EOF_TOKEN;
        }
        return (Token)this.tokens.get(i);
    }

    public TokenSource getTokenSource() {
        return this.source;
    }

    public String toString(int start, int stop) {
        this.assertSize(stop);
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i <= stop && i < this.tokens.size()) {
            XQToken token = this.tokens.get(i);
            this.appendWithPredecessors(sb, token);
            ++i;
        }
        return sb.toString();
    }

    public void appendWithPredecessors(StringBuilder target, XQToken t) {
        if (t.getHiddenPredecessor() != null) {
            this.appendWithPredecessors(target, t.getHiddenPredecessor());
        }
        target.append(t.getText());
    }

    public String toString(Token start, Token stop) {
        return this.toString(start.getTokenIndex(), stop.getTokenIndex());
    }

    public int LA(int i) {
        return this.LT(i).getType();
    }

    public String getSourceName() {
        return this.source.getSourceName();
    }

    public int index() {
        return this.offset;
    }

    public int mark() {
        this.lastMarker = this.offset;
        return this.lastMarker;
    }

    public void release(int marker) {
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void seek(int index) {
        this.offset = index;
    }

    public int size() {
        return this.tokens.size();
    }

    public void setSource(TokenSource source) {
        this.source = source;
    }

    public TokenSource getSource() {
        return this.source;
    }

    public int range() {
        return this.range;
    }
}

