/*
 * Decompiled with CFR 0.152.
 */
package com.martinprobst.xqpretty;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.helpers.XMLFilterImpl;

public class IndentationFilter
extends XMLFilterImpl {
    private static final boolean DEBUG = false;
    private static final char[] ONE_LINE_BREAK = new char[]{'\n'};
    private static final char ONE_WS = ' ';
    private static final int MAX_CONSECUTIVE_BREAKS = 2;
    private final boolean filterTags;
    private int consecutiveBreaks = 0;
    private boolean lastBreakWasOptional;
    private final ArrayList<Event> buffer = new ArrayList(5);
    private final ArrayList<Integer> tabMarks = new ArrayList(2);
    private static final BreakMarker BREAK_MARKER = new BreakMarker();
    private static final int MINOVERFLOW = 20;
    private static final int HTAB = 2;
    private static final int MAXLINELENGTH = 80;
    private int indent = 0;
    private int posInLine = 0;
    private boolean atStart = true;
    private boolean overflowLine = false;
    public int actualPosInLine;

    public IndentationFilter(boolean filterTags) {
        this.filterTags = filterTags;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        if (text.startsWith("(:") && text.endsWith(":)")) {
            this.comment(text);
            return;
        }
        String[] lines = text.split("\n");
        if (lines.length == 0) {
            return;
        }
        int i = 0;
        while (i < lines.length - 1) {
            this.indent();
            this.write(lines[i]);
            this.atStart = false;
            this.newline(false);
            ++i;
        }
        this.indent();
        this.write(lines[lines.length - 1]);
        if (ch[start + length - 1] == '\n') {
            this.newline(false);
        } else {
            this.atStart = false;
        }
    }

    private void comment(String text) throws SAXException {
        String[] lines = text.split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (!line.startsWith("(:")) {
                lines[i] = !(line = this.trimLeft(line)).startsWith(":") ? " : " + line : " " + line;
            }
            ++i;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.indent();
            this.write(line, false);
            this.atStart = false;
            this.newline(false);
            ++n2;
        }
    }

    public void superCharacters(String str) throws SAXException {
        this.actualPosInLine += str.length();
        super.characters(str.toCharArray(), 0, str.length());
    }

    private void write(String text) throws SAXException {
        this.write(text, true);
    }

    private void write(String text, boolean trim) throws SAXException {
        if (this.atStart && trim) {
            text = this.trimLeft(text);
        }
        this.consecutiveBreaks = 0;
        this.buffer.add(new StringEvent(text));
        this.posInLine += text.length();
        this.checkBreakLine();
    }

    private String trimLeft(String text) {
        int startOfText = 0;
        while (text.length() > startOfText && text.charAt(startOfText) == ' ') {
            ++startOfText;
        }
        text = text.substring(startOfText);
        return text;
    }

    private void checkBreakLine() throws SAXException {
        if (this.posInLine > 80) {
            Event event;
            int resultLength = this.posInLine;
            int breakPosition = this.buffer.size() - 1;
            while (breakPosition >= 0) {
                event = this.buffer.get(breakPosition);
                if (event == BREAK_MARKER && (resultLength -= event.length()) <= 80) {
                    this.buffer.remove(breakPosition);
                    break;
                }
                --breakPosition;
            }
            if (breakPosition < 0) {
                resultLength = this.posInLine;
                breakPosition = this.buffer.size() - 1;
                while (breakPosition > 0) {
                    event = this.buffer.get(breakPosition);
                    if ((resultLength -= event.length()) <= 80) break;
                    --breakPosition;
                }
            }
            int newPosInLine = this.posInLine - resultLength;
            int actualBreak = 0;
            int evLength = 0;
            while (actualBreak < this.buffer.size()) {
                Event event2 = this.buffer.get(actualBreak);
                if (event2 instanceof StringEvent && (evLength = ((StringEvent)event2).str.trim().length()) > 0) break;
                ++actualBreak;
            }
            if (++actualBreak > breakPosition) {
                newPosInLine -= evLength;
                breakPosition = actualBreak;
            }
            List<Event> nextLinePart = this.buffer.subList(breakPosition, this.buffer.size());
            ArrayList<Event> overflow = new ArrayList<Event>(nextLinePart);
            nextLinePart.clear();
            this.newline(false);
            this.overflowLine = true;
            this.indent();
            this.posInLine += newPosInLine;
            int i = 0;
            while (i < overflow.size()) {
                Event ev = overflow.get(i);
                if (ev instanceof StringEvent) {
                    StringEvent sev = (StringEvent)ev;
                    if (sev.str.trim().length() != 0) break;
                    this.posInLine -= sev.str.length();
                    overflow.remove(i);
                    break;
                }
                ++i;
            }
            this.buffer.addAll(overflow);
        }
    }

    private void newline(boolean forced) throws SAXException {
        if (this.atStart && this.lastBreakWasOptional) {
            this.lastBreakWasOptional = !forced;
            return;
        }
        boolean bl = this.lastBreakWasOptional = !forced;
        if (this.atStart) {
            if (this.consecutiveBreaks >= 2) {
                return;
            }
            if (!forced) {
                return;
            }
        }
        this.atStart = true;
        this.overflowLine = false;
        this.posInLine = 0;
        for (Event event : this.buffer) {
            event.play();
        }
        this.buffer.clear();
        ++this.consecutiveBreaks;
        this.actualPosInLine = 0;
        super.characters(ONE_LINE_BREAK, 0, 1);
    }

    private void indent() {
        if (this.atStart) {
            IndentOp indentOp = new IndentOp();
            this.buffer.add(indentOp);
            this.posInLine += indentOp.length();
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ("indent".equals(name)) {
            this.buffer.add(new IndentEvent());
        } else if ("br".equals(name)) {
            String brClass = atts.getValue("class");
            if (brClass != null) {
                if ("user".equals(brClass)) {
                    this.newline(true);
                } else if ("marker".equals(brClass)) {
                    this.buffer.add(BREAK_MARKER);
                } else {
                    this.newline(false);
                }
            } else {
                this.newline(false);
            }
        } else if ("tabmarker".equals(name)) {
            this.buffer.add(new TabMarker());
        } else if ("tabunmarker".equals(name)) {
            this.buffer.add(new TabUnmarker());
        } else if (!this.filterTags) {
            this.buffer.add(new ElementStartEvent(uri, localName, name, atts));
        }
    }

    public void superStartElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        super.startElement(uri, localName, name, atts);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("indent".equals(name)) {
            this.buffer.add(new UnIndentEvent());
        } else if (!("br".equals(name) || "tabmarker".equals(name) || "tabunmarker".equals(name) || this.filterTags)) {
            this.buffer.add(new ElementEndEvent(uri, localName, name));
        }
    }

    public void superEndElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
    }

    public void endDocument() throws SAXException {
        for (Event ev : this.buffer) {
            ev.play();
        }
        super.endDocument();
    }

    private static class BreakMarker
    extends Event {
        private BreakMarker() {
        }

        public void play() throws SAXException {
        }

        public String toString() {
            return "$BR$";
        }
    }

    private class ElementEndEvent
    extends Event {
        private final String uri;
        private final String localName;
        private final String name;

        private ElementEndEvent(String uri, String localName, String name) {
            this.uri = uri;
            this.localName = localName;
            this.name = name;
        }

        public void play() throws SAXException {
            IndentationFilter.this.superEndElement(this.uri, this.localName, this.name);
        }
    }

    private class ElementStartEvent
    extends Event {
        private final String uri;
        private final String localName;
        private final String name;
        private final Attributes atts;

        private ElementStartEvent(String uri, String localName, String name, Attributes atts) {
            this.uri = uri;
            this.localName = localName;
            this.name = name;
            this.atts = new Attributes2Impl(atts);
        }

        public void play() throws SAXException {
            IndentationFilter.this.superStartElement(this.uri, this.localName, this.name, this.atts);
        }
    }

    private static abstract class Event {
        private Event() {
        }

        public abstract void play() throws SAXException;

        public int length() {
            return 0;
        }
    }

    private class IndentEvent
    extends Event {
        private IndentEvent() {
        }

        public void play() throws SAXException {
            IndentationFilter indentationFilter = IndentationFilter.this;
            indentationFilter.indent = indentationFilter.indent + 2;
        }
    }

    private class IndentOp
    extends Event {
        private final boolean wasOverflow;

        private IndentOp() {
            this.wasOverflow = IndentationFilter.this.overflowLine;
        }

        private String getIndentString() {
            if (IndentationFilter.this.atStart) {
                StringBuilder res = new StringBuilder();
                int indents = IndentationFilter.this.indent;
                if (this.wasOverflow) {
                    if (IndentationFilter.this.tabMarks.size() > 0) {
                        int tabmark = 0;
                        int index = IndentationFilter.this.tabMarks.size() - 1;
                        while (index >= 0) {
                            tabmark = (Integer)IndentationFilter.this.tabMarks.get(index);
                            if (IndentationFilter.this.posInLine + tabmark < 60) break;
                            --index;
                        }
                        if (index >= 0) {
                            int k = 0;
                            while (k < tabmark) {
                                res.append(' ');
                                ++k;
                            }
                            return res.toString();
                        }
                    }
                    indents += 4;
                }
                int k = 0;
                while (k < indents) {
                    res.append(' ');
                    ++k;
                }
                return res.toString();
            }
            return "";
        }

        public void play() throws SAXException {
            IndentationFilter.this.superCharacters(this.getIndentString());
        }

        public int length() {
            return this.getIndentString().length();
        }
    }

    private class StringEvent
    extends Event {
        private final String str;

        public StringEvent(String str) {
            this.str = str;
        }

        public void play() throws SAXException {
            IndentationFilter.this.superCharacters(this.str);
        }

        public String toString() {
            return this.str;
        }

        public int length() {
            return this.str.length();
        }
    }

    private class TabMarker
    extends Event {
        private final int tabPos;

        private TabMarker() {
            this.tabPos = IndentationFilter.this.posInLine;
        }

        public void play() {
            IndentationFilter.this.tabMarks.add(this.tabPos);
        }

        public String toString() {
            return "$->$";
        }
    }

    private class TabUnmarker
    extends Event {
        private TabUnmarker() {
        }

        public void play() throws SAXException {
            IndentationFilter.this.tabMarks.remove(IndentationFilter.this.tabMarks.size() - 1);
        }

        public String toString() {
            return "$<-$";
        }
    }

    private class UnIndentEvent
    extends Event {
        private UnIndentEvent() {
        }

        public void play() throws SAXException {
            IndentationFilter indentationFilter = IndentationFilter.this;
            indentationFilter.indent = indentationFilter.indent - 2;
        }
    }
}

