/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.NumberingStyle;
import org.zwobble.mammoth.internal.documents.Style;
import org.zwobble.mammoth.internal.util.Maps;

public class Styles {
    public static final Styles EMPTY = new Styles(Maps.map(), Maps.map(), Maps.map(), Maps.map());
    private final Map<String, Style> paragraphStyles;
    private final Map<String, Style> characterStyles;
    private final Map<String, Style> tableStyles;
    private final Map<String, NumberingStyle> numberingStyles;

    public Styles(Map<String, Style> paragraphStyles, Map<String, Style> characterStyles, Map<String, Style> tableStyles, Map<String, NumberingStyle> numberingStyles) {
        this.paragraphStyles = paragraphStyles;
        this.characterStyles = characterStyles;
        this.tableStyles = tableStyles;
        this.numberingStyles = numberingStyles;
    }

    public Optional<Style> findParagraphStyleById(String id) {
        return Maps.lookup(this.paragraphStyles, id);
    }

    public Optional<Style> findCharacterStyleById(String id) {
        return Maps.lookup(this.characterStyles, id);
    }

    public Optional<Style> findTableStyleById(String id) {
        return Maps.lookup(this.tableStyles, id);
    }

    public Optional<NumberingStyle> findNumberingStyleById(String id) {
        return Maps.lookup(this.numberingStyles, id);
    }
}

