/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.List;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.Note;
import org.zwobble.mammoth.internal.documents.NoteType;
import org.zwobble.mammoth.internal.docx.BodyXmlReader;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.xml.XmlElement;

public class NotesXmlReader {
    private final BodyXmlReader bodyReader;
    private final String tagName;
    private final NoteType noteType;

    public static NotesXmlReader footnote(BodyXmlReader bodyReader) {
        return new NotesXmlReader(bodyReader, "footnote", NoteType.FOOTNOTE);
    }

    public static NotesXmlReader endnote(BodyXmlReader bodyReader) {
        return new NotesXmlReader(bodyReader, "endnote", NoteType.ENDNOTE);
    }

    private NotesXmlReader(BodyXmlReader bodyReader, String tagName, NoteType noteType) {
        this.bodyReader = bodyReader;
        this.tagName = tagName;
        this.noteType = noteType;
    }

    public InternalResult<List<Note>> readElement(XmlElement element) {
        Iterable<XmlElement> elements = Iterables.lazyFilter(element.findChildren("w:" + this.tagName), this::isNoteElement);
        return InternalResult.flatMap(elements, this::readNoteElement);
    }

    private boolean isNoteElement(XmlElement element) {
        return element.getAttributeOrNone("w:type").map(type -> !this.isSeparatorType((String)type)).orElse(true);
    }

    private boolean isSeparatorType(String type) {
        return type.equals("continuationSeparator") || type.equals("separator");
    }

    private InternalResult<Note> readNoteElement(XmlElement element) {
        return this.bodyReader.readElements(element.getChildren()).toResult().map(children -> new Note(this.noteType, element.getAttribute("w:id"), (List<DocumentElement>)children));
    }
}

