/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Comment;
import org.zwobble.mammoth.internal.documents.Document;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.Notes;
import org.zwobble.mammoth.internal.docx.BodyXmlReader;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlElementLike;

public class DocumentXmlReader {
    private final BodyXmlReader bodyReader;
    private final Notes notes;
    private final List<Comment> comments;
    private Optional<Path> documentPath = Optional.empty();

    public DocumentXmlReader(Optional<Path> documentPath, BodyXmlReader bodyReader, Notes notes, List<Comment> comments) {
        this.documentPath = documentPath;
        this.bodyReader = bodyReader;
        this.notes = notes;
        this.comments = comments;
    }

    public DocumentXmlReader(BodyXmlReader bodyReader, Notes notes, List<Comment> comments) {
        this.bodyReader = bodyReader;
        this.notes = notes;
        this.comments = comments;
    }

    public InternalResult<Document> readElement(XmlElement element) {
        XmlElementLike body = element.findChildOrEmpty("w:body");
        return this.bodyReader.readElements(body.getChildren()).toResult().map(children -> new Document(this.documentPath, (List<DocumentElement>)children, this.notes, this.comments));
    }
}

