/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.documents;

import java.util.Optional;

public class Style {
    private final String styleId;
    private final Optional<String> name;
    boolean isCustom;
    Optional<String> parentStyleId;

    public Style(String styleId, Optional<String> name) {
        this(styleId, name, Optional.empty(), false);
    }

    public Style(String styleId, Optional<String> name, Optional<String> parentStyleId, boolean isCustom) {
        this.styleId = styleId;
        this.name = name;
        this.parentStyleId = parentStyleId;
        this.isCustom = isCustom;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public String describe() {
        String styleIdDescription = "Style ID: " + this.styleId;
        return this.name.map(name -> name + " (" + styleIdDescription + ")").orElse(styleIdDescription);
    }

    public Optional<String> getParentStyleId() {
        return this.parentStyleId;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public String toString() {
        return "Style [styleId=" + this.styleId + ", name=" + this.name + ", isCustom=" + this.isCustom + ", parentStyleId=" + this.parentStyleId + "]";
    }
}

