/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.documents;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Note;
import org.zwobble.mammoth.internal.documents.NoteType;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;

public class Notes {
    public static final Notes EMPTY = new Notes(Lists.list());
    private final Map<NoteType, Map<String, Note>> notes;

    public Notes(List<Note> notes) {
        this.notes = Maps.eagerMapValues(Maps.toMultiMapWithKey(notes, Note::getNoteType), notesOfType -> Maps.toMapWithKey(notesOfType, Note::getId));
    }

    public Optional<Note> findNote(NoteType noteType, String noteId) {
        return Maps.lookup(this.notes, noteType).flatMap(notesOfType -> Maps.lookup(notesOfType, noteId));
    }
}

