/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.conversion;

import org.zwobble.mammoth.images.ImageConverter;
import org.zwobble.mammoth.internal.conversion.InternalImageConverter;
import org.zwobble.mammoth.internal.conversion.UnknownStylesReporter;
import org.zwobble.mammoth.internal.styles.DefaultStyles;
import org.zwobble.mammoth.internal.styles.StyleMap;
import org.zwobble.mammoth.internal.styles.parsing.StyleMapParser;
import org.zwobble.mammoth.internal.util.Base64Encoding;
import org.zwobble.mammoth.internal.util.Maps;

public class DocumentToHtmlOptions {
    public static final DocumentToHtmlOptions DEFAULT = new DocumentToHtmlOptions("", false, StyleMap.EMPTY, StyleMap.EMPTY, false, false, InternalImageConverter.imgElement(image -> {
        String base64 = Base64Encoding.streamToBase64(image::getInputStream);
        String src = "data:" + image.getContentType() + ";base64," + base64;
        return Maps.map("src", src);
    }));
    private final String idPrefix;
    private final boolean preserveEmptyParagraphs;
    private final StyleMap styleMap;
    private final StyleMap embeddedStyleMap;
    private final boolean disableDefaultStyleMap;
    private final boolean disableEmbeddedStyleMap;
    private final InternalImageConverter imageConverter;
    private final UnknownStylesReporter unknownStylesReporter;
    private final boolean shouldConvertNotesToList;

    public DocumentToHtmlOptions(String idPrefix, boolean preserveEmptyParagraphs, StyleMap styleMap, StyleMap embeddedStyleMap, boolean disableDefaultStyleMap, boolean disableEmbeddedStyleMap, InternalImageConverter imageConverter) {
        this(idPrefix, preserveEmptyParagraphs, styleMap, embeddedStyleMap, disableDefaultStyleMap, disableEmbeddedStyleMap, imageConverter, true, null);
    }

    public DocumentToHtmlOptions(String idPrefix, boolean preserveEmptyParagraphs, StyleMap styleMap, StyleMap embeddedStyleMap, boolean disableDefaultStyleMap, boolean disableEmbeddedStyleMap, InternalImageConverter imageConverter, boolean shouldConvertNotesToList, UnknownStylesReporter unknownStylesReporter) {
        this.idPrefix = idPrefix;
        this.preserveEmptyParagraphs = preserveEmptyParagraphs;
        this.styleMap = styleMap;
        this.embeddedStyleMap = embeddedStyleMap;
        this.disableDefaultStyleMap = disableDefaultStyleMap;
        this.disableEmbeddedStyleMap = disableEmbeddedStyleMap;
        this.imageConverter = imageConverter;
        this.shouldConvertNotesToList = shouldConvertNotesToList;
        this.unknownStylesReporter = unknownStylesReporter;
    }

    public DocumentToHtmlOptions idPrefix(String prefix) {
        return new DocumentToHtmlOptions(prefix, this.preserveEmptyParagraphs, this.styleMap, this.embeddedStyleMap, this.disableDefaultStyleMap, this.disableEmbeddedStyleMap, this.imageConverter, this.shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public DocumentToHtmlOptions preserveEmptyParagraphs() {
        return new DocumentToHtmlOptions(this.idPrefix, true, this.styleMap, this.embeddedStyleMap, this.disableDefaultStyleMap, this.disableEmbeddedStyleMap, this.imageConverter, this.shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public DocumentToHtmlOptions setConvertNotesToList(boolean shouldConvertNotesToList) {
        return new DocumentToHtmlOptions(this.idPrefix, this.preserveEmptyParagraphs, this.styleMap, this.embeddedStyleMap, this.disableDefaultStyleMap, this.disableEmbeddedStyleMap, this.imageConverter, shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public DocumentToHtmlOptions setUnknownStylesReporter(UnknownStylesReporter unknownStylesReporter) {
        return new DocumentToHtmlOptions(this.idPrefix, this.preserveEmptyParagraphs, this.styleMap, this.embeddedStyleMap, this.disableDefaultStyleMap, this.disableEmbeddedStyleMap, this.imageConverter, this.shouldConvertNotesToList, unknownStylesReporter);
    }

    public DocumentToHtmlOptions addStyleMap(String styleMap) {
        return this.addStyleMap(StyleMapParser.parse(styleMap));
    }

    public DocumentToHtmlOptions addStyleMap(StyleMap styleMap) {
        return new DocumentToHtmlOptions(this.idPrefix, this.preserveEmptyParagraphs, this.styleMap.update(styleMap), this.embeddedStyleMap, this.disableDefaultStyleMap, this.disableEmbeddedStyleMap, this.imageConverter, this.shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public DocumentToHtmlOptions disableDefaultStyleMap() {
        return new DocumentToHtmlOptions(this.idPrefix, this.preserveEmptyParagraphs, this.styleMap, this.embeddedStyleMap, true, this.disableEmbeddedStyleMap, this.imageConverter, this.shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public DocumentToHtmlOptions disableEmbeddedStyleMap() {
        return new DocumentToHtmlOptions(this.idPrefix, this.preserveEmptyParagraphs, this.styleMap, this.embeddedStyleMap, this.disableDefaultStyleMap, true, this.imageConverter, this.shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public DocumentToHtmlOptions addEmbeddedStyleMap(StyleMap embeddedStyleMap) {
        return new DocumentToHtmlOptions(this.idPrefix, this.preserveEmptyParagraphs, this.styleMap, embeddedStyleMap, this.disableDefaultStyleMap, this.disableEmbeddedStyleMap, this.imageConverter, this.shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public DocumentToHtmlOptions imageConverter(ImageConverter.ImgElement imageConverter) {
        return new DocumentToHtmlOptions(this.idPrefix, this.preserveEmptyParagraphs, this.styleMap, this.embeddedStyleMap, this.disableDefaultStyleMap, this.disableEmbeddedStyleMap, InternalImageConverter.imgElement(imageConverter), this.shouldConvertNotesToList, this.unknownStylesReporter);
    }

    public String idPrefix() {
        return this.idPrefix;
    }

    public boolean shouldPreserveEmptyParagraphs() {
        return this.preserveEmptyParagraphs;
    }

    public StyleMap styleMap() {
        StyleMap styleMap = StyleMap.EMPTY;
        if (!this.disableDefaultStyleMap) {
            styleMap = styleMap.update(DefaultStyles.DEFAULT_STYLE_MAP);
        }
        if (!this.disableEmbeddedStyleMap) {
            styleMap = styleMap.update(this.embeddedStyleMap);
        }
        styleMap = styleMap.update(this.styleMap);
        return styleMap;
    }

    public InternalImageConverter imageConverter() {
        return this.imageConverter;
    }

    public boolean shouldConvertNotesToList() {
        return this.shouldConvertNotesToList;
    }

    public UnknownStylesReporter getUnknownStylesReporter() {
        return this.unknownStylesReporter;
    }
}

