/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.IAction;
import org.dita.dost.platform.Plugin;
import org.dita.dost.platform.Value;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

class InsertAction
extends XMLFilterImpl
implements IAction {
    private final XMLReader reader;
    private DITAOTLogger logger;
    private final Set<Value> fileNameSet = new LinkedHashSet<Value>(16);
    final Map<String, String> paramTable = new HashMap<String, String>();
    private int elemLevel = 0;
    String currentFile;

    public InsertAction() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.reader = factory.newSAXParser().getXMLReader();
            this.reader.setContentHandler(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize parser: " + e.getMessage(), e);
        }
    }

    public void setInput(List<Value> input) {
        this.fileNameSet.addAll(input);
    }

    public void addParam(String name, String value) {
        this.paramTable.put(name, value);
    }

    public String getResult() {
        throw new UnsupportedOperationException();
    }

    public void getResult(ContentHandler retBuf) throws SAXException {
        this.setContentHandler(retBuf);
        try {
            for (Value fileName : this.fileNameSet) {
                if (fileName instanceof Value.PathValue) {
                    Value.PathValue pathValue = (Value.PathValue)fileName;
                    this.currentFile = pathValue.getPath();
                    try {
                        new URL(this.currentFile);
                    }
                    catch (MalformedURLException ex) {
                        this.currentFile = new File(this.currentFile).toURI().toASCIIString();
                    }
                } else {
                    this.logger.error("Catalog import must be a file feature: " + fileName.value());
                    continue;
                }
                this.reader.parse(this.currentFile);
            }
        }
        catch (RuntimeException | SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setFeatures(Map<String, Plugin> h) {
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.elemLevel != 0) {
            this.getContentHandler().startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.elemLevel != 0) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.elemLevel != 0) {
            this.getContentHandler().startElement(uri, localName, qName, attributes);
        }
        ++this.elemLevel;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.elemLevel;
        if (this.elemLevel != 0) {
            this.getContentHandler().endElement(uri, localName, qName);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.elemLevel = 0;
    }

    @Override
    public void endDocument() throws SAXException {
    }
}

