/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.CopyToReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.ForceUniqueFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

public final class CopyToModule
extends AbstractPipelineModuleImpl {
    private TempFileNameScheme tempFileNameScheme;
    private boolean forceUnique;
    private ForceUniqueFilter forceUniqueFilter;
    private final CopyToReader reader = new CopyToReader();

    public void setJob(Job job) {
        super.setJob(job);
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(job.getInputDir());
    }

    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        try {
            this.init(input);
            this.processMap();
            Map<Job.FileInfo, Job.FileInfo> copyToMap = this.getCopyToMap();
            this.performCopytoTask(copyToMap);
            this.job.write();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to process copy-to attributes: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void init(AbstractPipelineInput input) {
        this.forceUnique = Boolean.parseBoolean(input.getAttribute("force-unique"));
    }

    private void processMap() throws DITAOTException {
        URI in = this.job.tempDirURI.resolve(((Job.FileInfo)this.job.getFileInfo((Predicate<Job.FileInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processMap$0(org.dita.dost.util.Job$FileInfo ), (Lorg/dita/dost/util/Job$FileInfo;)Z)()).iterator().next()).uri);
        List<XMLFilter> pipe = this.getProcessingPipe(in);
        this.job.getStore().transform(in, pipe);
    }

    private List<XMLFilter> getProcessingPipe(URI fileToParse) {
        ArrayList<XMLFilter> pipe = new ArrayList<XMLFilter>();
        if (this.forceUnique) {
            this.forceUniqueFilter = new ForceUniqueFilter();
            this.forceUniqueFilter.setLogger(this.logger);
            this.forceUniqueFilter.setJob(this.job);
            this.forceUniqueFilter.setCurrentFile(fileToParse);
            this.forceUniqueFilter.setTempFileNameScheme(this.tempFileNameScheme);
            pipe.add((XMLFilter)this.forceUniqueFilter);
        }
        this.reader.setJob(this.job);
        this.reader.setLogger(this.logger);
        this.reader.setCurrentFile(fileToParse);
        pipe.add((XMLFilter)this.reader);
        return pipe;
    }

    private Map<Job.FileInfo, Job.FileInfo> getCopyToMap() {
        HashMap<Job.FileInfo, Job.FileInfo> copyToMap = new HashMap<Job.FileInfo, Job.FileInfo>();
        if (this.forceUnique) {
            this.forceUniqueFilter.copyToMap.forEach((dstFi, srcFi) -> {
                this.job.add(dstFi);
                copyToMap.put((Job.FileInfo)dstFi, (Job.FileInfo)srcFi);
            });
        }
        for (Map.Entry e : this.reader.getCopyToMap().entrySet()) {
            URI target = this.job.tempDirURI.relativize((URI)e.getKey());
            Job.FileInfo targetFi = this.job.getFileInfo(target);
            URI source = this.job.tempDirURI.relativize((URI)e.getValue());
            Job.FileInfo sourceFi = this.job.getFileInfo(source);
            if (targetFi == null || targetFi != null && targetFi.src != null) continue;
            copyToMap.put(targetFi, sourceFi);
        }
        return copyToMap;
    }

    private void performCopytoTask(Map<Job.FileInfo, Job.FileInfo> copyToMap) {
        for (Map.Entry<Job.FileInfo, Job.FileInfo> entry : copyToMap.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            URI copytoTarget = entry.getKey().uri;
            URI copytoSource = entry.getValue().uri;
            URI srcFile = this.job.tempDirURI.resolve(copytoSource);
            URI targetFile = this.job.tempDirURI.resolve(copytoTarget);
            if (this.job.getStore().exists(targetFile)) {
                this.logger.warn(MessageUtils.getMessage((String)"DOTX064W", (String[])new String[]{copytoTarget.getPath()}).toString());
                continue;
            }
            Job.FileInfo input = (Job.FileInfo)this.job.getFileInfo(fi -> fi.isInput).iterator().next();
            URI inputMapInTemp = this.job.tempDirURI.resolve(input.uri);
            this.copyFileWithPIReplaced(srcFile, targetFile, copytoTarget, inputMapInTemp);
            Job.FileInfo src = this.job.getFileInfo(copytoSource);
            assert (src != null);
            Job.FileInfo dst = this.job.getFileInfo(copytoTarget);
            assert (dst != null);
            URI dstTemp = this.tempFileNameScheme.generateTempFileName(dst.result);
            Job.FileInfo res = new Job.FileInfo.Builder(src).result(dst.result).uri(dstTemp).build();
            this.job.add(res);
        }
    }

    private void copyFileWithPIReplaced(URI src, URI target, URI copytoTargetFilename, URI inputMapInTemp) {
        assert (src.isAbsolute());
        assert (target.isAbsolute());
        assert (!copytoTargetFilename.isAbsolute());
        assert (inputMapInTemp.isAbsolute());
        File workdir = new File(target).getParentFile();
        File path2project = CopyToModule.getPathtoProject(copytoTargetFilename, target, inputMapInTemp, this.job);
        File path2rootmap = CopyToModule.getPathtoRootmap(target, inputMapInTemp);
        CopyToFilter filter = new CopyToFilter(workdir, path2project, path2rootmap, src, target);
        this.logger.info("Processing " + src + " to " + target);
        try {
            this.job.getStore().transform(src, target, Collections.singletonList(filter));
        }
        catch (DITAOTException e) {
            this.logger.error("Failed to write copy-to file: " + e.getMessage(), (Throwable)e);
        }
    }

    public static File getPathtoProject(URI filename, URI traceFilename, URI inputMap, Job job) {
        assert (traceFilename.isAbsolute());
        assert (inputMap.isAbsolute());
        if (job.getGeneratecopyouter() != Job.Generate.OLDSOLUTION) {
            if (CopyToModule.isOutFile(traceFilename, inputMap)) {
                return URLUtils.toFile((String)CopyToModule.getRelativePathFromOut(traceFilename, job));
            }
            return URLUtils.toFile((URI)URLUtils.getRelativePath((URI)traceFilename, (URI)inputMap)).getParentFile();
        }
        return URLUtils.toFile((URI)URLUtils.getRelativePath((URI)filename));
    }

    public static File getPathtoRootmap(URI traceFilename, URI inputMap) {
        assert (traceFilename.isAbsolute());
        assert (inputMap.isAbsolute());
        return URLUtils.toFile((URI)URLUtils.getRelativePath((URI)traceFilename, (URI)inputMap)).getParentFile();
    }

    private static String getRelativePathFromOut(URI overflowingFile, Job job) {
        URI relativePath = URLUtils.getRelativePath((URI)job.getInputFile(), (URI)overflowingFile);
        URI outputDir = job.getOutputDir().getAbsoluteFile().toURI();
        URI outputPathName = outputDir.resolve("index.html");
        URI finalOutFilePathName = outputDir.resolve(relativePath.getPath());
        URI finalRelativePathName = URLUtils.getRelativePath((URI)finalOutFilePathName, (URI)outputPathName);
        File parentDir = URLUtils.toFile((URI)finalRelativePathName).getParentFile();
        if (parentDir == null || parentDir.getPath().isEmpty()) {
            parentDir = new File(".");
        }
        return parentDir.getPath() + File.separator;
    }

    private static boolean isOutFile(URI filePathName, URI inputMap) {
        URI relativePath = URLUtils.getRelativePath((URI)inputMap, (URI)filePathName);
        return relativePath.getPath().length() != 0 && relativePath.getPath().startsWith("..");
    }

    private static /* synthetic */ boolean lambda$processMap$0(Job.FileInfo fi) {
        return fi.isInput;
    }

    private static final class CopyToFilter
    extends XMLFilterImpl {
        private final File workdir;
        private final File path2project;
        private final File path2rootmap;
        private final URI src;
        private final URI dst;

        CopyToFilter(File workdir, File path2project, File path2rootmap, URI src, URI dst) {
            assert (workdir != null);
            this.workdir = workdir;
            this.path2project = path2project;
            this.path2rootmap = path2rootmap;
            this.src = src;
            this.dst = dst;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String value;
            Attributes resAtts = atts;
            if ((Constants.TOPIC_XREF.matches(atts) || Constants.TOPIC_LINK.matches(atts) || Constants.TOPIC_IMAGE.matches(atts)) && !Objects.equals("external", atts.getValue("scope")) && (value = atts.getValue("href")) != null && !value.startsWith("#")) {
                resAtts = new XMLUtils.AttributesBuilder(atts).add("href", this.updateHref(value)).build();
            }
            this.getContentHandler().startElement(uri, localName, qName, resAtts);
        }

        private String updateHref(String value) {
            URI absSrc = this.src.resolve(value);
            return URLUtils.getRelativePath((URI)this.dst, (URI)absSrc).toString();
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            Object d = data;
            switch (target) {
                case "workdir": {
                    try {
                        if (!Constants.OS_NAME.toLowerCase().contains("windows")) {
                            d = this.workdir.getCanonicalPath();
                            break;
                        }
                        d = "/" + this.workdir.getCanonicalPath();
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to get canonical path for working directory: " + e.getMessage(), e);
                    }
                }
                case "workdir-uri": {
                    d = URLUtils.toDirURI((File)this.workdir).toString();
                    break;
                }
                case "path2project": {
                    if (this.path2project != null) {
                        d = this.path2project.getPath();
                        break;
                    }
                    d = "";
                    break;
                }
                case "path2project-uri": {
                    if (this.path2project != null) {
                        d = URLUtils.toURI((File)this.path2project).toString();
                        if (((String)d).endsWith("/")) break;
                        d = (String)d + "/";
                        break;
                    }
                    d = "";
                    break;
                }
                case "path2rootmap-uri": {
                    if (this.path2rootmap != null) {
                        d = URLUtils.toURI((File)this.path2rootmap).toString();
                        if (((String)d).endsWith("/")) break;
                        d = (String)d + "/";
                        break;
                    }
                    d = "";
                }
            }
            this.getContentHandler().processingInstruction(target, (String)d);
        }
    }
}

