/*
 * Decompiled with CFR 0.152.
 */
package com.idiominc.ws.opentopic.fo.index2;

import com.idiominc.ws.opentopic.fo.index2.IndexEntry;
import com.idiominc.ws.opentopic.fo.index2.IndexPreprocessResult;
import com.idiominc.ws.opentopic.fo.index2.IndexPreprocessor;
import com.idiominc.ws.opentopic.fo.index2.configuration.IndexConfiguration;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.XMLCatalog;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Job;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

@Deprecated
public class IndexPreprocessorTaskJob
extends Task {
    private String input = "";
    private String output = "";
    private XMLCatalog xmlcatalog;
    private String locale = "ja";
    private String indexConfig = "";
    private String draft = "no";
    public static boolean failOnError = false;
    public static boolean processingFaild = false;
    private static final String prefix = "opentopic-index";
    private static final String namespace_url = "http://www.idiominc.com/opentopic/index";

    public static void main(String[] args) {
        new IndexPreprocessorTaskJob().execute();
    }

    public void execute() throws BuildException {
        this.checkParameters();
        XMLUtils xmlUtils = (XMLUtils)this.getProject().getReference("xmlutils");
        try {
            DocumentBuilder documentBuilder = xmlUtils.getDocumentBuilder();
            documentBuilder.setEntityResolver((EntityResolver)this.xmlcatalog);
            File inputFile = this.input.startsWith("file:") ? new File(new URI(this.input)) : new File(this.input);
            Job job = (Job)this.getProject().getReference("job");
            InputStream is = job.getStore().getInputStream(inputFile.toURI());
            Document doc = documentBuilder.parse(is, inputFile.toURI().toString());
            IndexPreprocessor preprocessor = new IndexPreprocessor(prefix, namespace_url, this.draft);
            preprocessor.setLogger((DITAOTLogger)new DITAOTAntLogger(this.getProject()));
            preprocessor.setXmlUtils(xmlUtils);
            IndexPreprocessResult result = preprocessor.process(doc);
            Document resultDoc = result.getDocument();
            IndexConfiguration configuration = IndexConfiguration.parse((Document)documentBuilder.parse(this.indexConfig));
            IndexEntry[] indexEntries = result.getIndexEntries();
            Locale loc = this.locale.indexOf("-") == 2 || this.locale.indexOf("_") == 2 ? new Locale(this.locale.substring(0, 2), this.locale.substring(3)) : new Locale(this.locale);
            preprocessor.createAndAddIndexGroups(indexEntries, configuration, resultDoc, loc);
            if (processingFaild) {
                this.setActiveProjectProperty("ws.runtime.index.preprocess.fail", "true");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            if (doc.getDoctype() != null) {
                if (null != doc.getDoctype().getPublicId()) {
                    transformer.setOutputProperty("doctype-public", doc.getDoctype().getPublicId());
                }
                if (null != doc.getDoctype().getSystemId()) {
                    transformer.setOutputProperty("doctype-system", doc.getDoctype().getSystemId());
                }
            }
            File outputFile = this.output.startsWith("file:") ? new File(new URI(this.output)) : new File(this.output);
            OutputStream out = job.getStore().getOutputStream(outputFile.toURI());
            StreamResult streamResult = new StreamResult(out);
            transformer.transform(new DOMSource(resultDoc), streamResult);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void checkParameters() throws BuildException {
        if (null == this.locale || null == this.input || null == this.output || null == this.indexConfig) {
            throw new BuildException("locale, indexConfig, input, output attributes are required");
        }
    }

    public void setInput(String theInput) {
        this.input = theInput;
    }

    public void setOutput(String theOutput) {
        this.output = theOutput;
    }

    public void addConfiguredXmlcatalog(XMLCatalog xmlcatalog) {
        this.xmlcatalog = xmlcatalog;
    }

    public void setLocale(String theLocale) {
        this.locale = theLocale;
    }

    public void setIndexConfig(String theIndexConfig) {
        this.indexConfig = theIndexConfig;
    }

    public void setFailOnError(String theFailOnErro) {
        failOnError = theFailOnErro.equals("true");
    }

    public void setDraft(String draftValue) {
        this.draft = draftValue;
    }

    private void setActiveProjectProperty(String propertyName, String propertyValue) {
        Project activeProject = this.getProject();
        if (activeProject != null) {
            activeProject.setProperty(propertyName, propertyValue);
        }
    }
}

