/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml.imagemap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.imagemap.ImageMapFormatException;
import ro.sync.ecss.extensions.api.webapp.imagemap.WebappAreaView;
import ro.sync.ecss.extensions.api.webapp.imagemap.WebappAreaViewFactory;
import ro.sync.ecss.extensions.api.webapp.imagemap.WebappImageMapSupport;
import ro.sync.exml.view.graphics.Circle;
import ro.sync.exml.view.graphics.Polygon;
import ro.sync.exml.view.graphics.Rectangle;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLWebappImageMapSupport
implements WebappImageMapSupport {
    private List<WebappAreaView> areaViews;

    public XHTMLWebappImageMapSupport(AuthorElement map) throws ImageMapFormatException {
        this.areaViews = this.computeAreas(map);
    }

    public List<WebappAreaView> getAreas(int fontSize) {
        return this.areaViews;
    }

    private List<WebappAreaView> computeAreas(AuthorElement map) throws ImageMapFormatException {
        ArrayList<WebappAreaView> views = new ArrayList<WebappAreaView>();
        List children = map.getContentNodes();
        for (int i = 0; i < children.size(); ++i) {
            AuthorNode child = (AuthorNode)children.get(i);
            views.add(this.areaToAreaView((AuthorElement)child, i));
        }
        return views;
    }

    private WebappAreaView areaToAreaView(AuthorElement area, int originalLayer) throws ImageMapFormatException {
        WebappAreaView view;
        AttrValue shapeNameAttr = area.getAttribute("shape");
        if (shapeNameAttr == null) {
            throw new ImageMapFormatException("no shape");
        }
        String shapeName = shapeNameAttr.getValue();
        List<Integer> coords = this.parseCoords(area);
        if ("circle".equals(shapeName)) {
            view = this.createCircle(coords, originalLayer);
        } else if ("poly".equals(shapeName)) {
            view = this.createPolygon(coords, originalLayer);
        } else if ("rect".equals(shapeName)) {
            view = this.createRectangle(coords, originalLayer);
        } else {
            throw new ImageMapFormatException("Unsupported shape: " + shapeName);
        }
        return view;
    }

    private WebappAreaView createPolygon(List<Integer> coords, int originalLayer) {
        Polygon poly = new Polygon();
        for (int i = 0; i < coords.size() / 2; ++i) {
            poly.addPoint(coords.get(2 * i).intValue(), coords.get(2 * i + 1).intValue());
        }
        return WebappAreaViewFactory.createPolygon((Polygon)poly, (int)originalLayer);
    }

    private WebappAreaView createRectangle(List<Integer> coords, int originalLayer) {
        Rectangle rect = new Rectangle(coords.get(0).intValue(), coords.get(1).intValue(), coords.get(2) - coords.get(0), coords.get(3) - coords.get(1));
        return WebappAreaViewFactory.createRectangle((Rectangle)rect, (int)originalLayer);
    }

    private WebappAreaView createCircle(List<Integer> coords, int originalLayer) {
        Circle circle = new Circle(coords.get(0).intValue(), coords.get(1).intValue(), coords.get(2).intValue());
        return WebappAreaViewFactory.createCircle((Circle)circle, (int)originalLayer);
    }

    private List<Integer> parseCoords(AuthorElement area) throws ImageMapFormatException {
        AttrValue coordsAttr = area.getAttribute("coords");
        if (coordsAttr == null) {
            throw new ImageMapFormatException("Invalid coordinates: " + area);
        }
        String[] coords = coordsAttr.getValue().split(",");
        List<Integer> coordInts = Arrays.stream(coords).map(Integer::parseInt).collect(Collectors.toList());
        return coordInts;
    }

    public Optional<Rectangle> getImageSize(int fontSize) {
        return Optional.empty();
    }
}

