/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.operations.InsertListOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
public class XHTMLInsertListOperation
extends InsertListOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)XHTMLInsertListOperation.class.getName());
    static final String ORDERED_LIST = "orderedlist";
    static final String UNORDERED_LIST = "unorderedlist";
    static final String DEFINITION_LIST = "definitionlist";
    static final Set<String> LIST_ELEMENTS = ImmutableSet.of((Object)"orderedlist", (Object)"unorderedlist", (Object)"definitionlist");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, new ArgumentDescriptor("listType", 3, "Controls the type of list to be inserted. Accepted values are: orderedlist, unorderedlist, definitionlist. Default value is orderedlist.", new String[]{"orderedlist", "unorderedlist", "definitionlist"}, "orderedlist"), CONVERT_ELEMENT_AT_CARET_ARGUMENT_DESCRIPTOR};

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Convert the selected paragraph(s) to an ordered/unordered/definition list.";
    }

    @Override
    protected void insertContent(AuthorAccess authorAccess, AuthorNode listNode, List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFragmentsInfos) {
        if (listNode instanceof AuthorElement) {
            List contentNodes = ((AuthorElement)listNode).getContentNodes();
            int k = 0;
            for (int i = 0; i < contentNodes.size(); ++i) {
                AuthorNode authorNode;
                boolean shouldAddPara = false;
                List fragContentNodes = selectedFragmentsInfos.get(k).getSelectedFragment().getContentNodes();
                for (AuthorNode fragNode : fragContentNodes) {
                    Styles styles = authorAccess.getEditorAccess().getStyles(fragNode);
                    String display = styles.getDisplay();
                    shouldAddPara = !"block".equals(display);
                }
                StringBuilder xmlFragment = new StringBuilder();
                String namespace = this.getNamespace();
                if (shouldAddPara) {
                    Map<String, String> attributes;
                    xmlFragment.append("<p");
                    if (namespace != null) {
                        xmlFragment.append(" xmlns=\"").append(namespace).append("\"");
                    }
                    if ((attributes = selectedFragmentsInfos.get(k).getAttributes()) != null) {
                        Set<String> names = attributes.keySet();
                        for (String attrName : names) {
                            if ("id".equals(attrName)) continue;
                            xmlFragment.append(" ").append(attrName).append("=\"").append(attributes.get(attrName)).append("\"");
                        }
                    }
                    xmlFragment.append(">");
                }
                if (!((authorNode = (AuthorNode)contentNodes.get(i)) instanceof AuthorElement)) continue;
                String localName = ((AuthorElement)authorNode).getLocalName();
                if (k >= selectedFragmentsInfos.size() || !"li".equals(localName) && !"dd".equals(localName)) continue;
                try {
                    xmlFragment.append(authorAccess.getDocumentController().serializeFragmentToXML(selectedFragmentsInfos.get(k).getSelectedFragment()));
                    if (shouldAddPara) {
                        xmlFragment.append("</p>");
                    }
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment.toString(), authorNode.getStartOffset() + 1, 7, false);
                    ++k;
                    continue;
                }
                catch (BadLocationException | AuthorOperationException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    protected String getNamespace() {
        return "http://www.w3.org/1999/xhtml";
    }

    @Override
    protected String getXMLFragment(AuthorAccess authorAccess, String listType, String parentListType) {
        StringBuilder frag = new StringBuilder();
        String namespace = this.getNamespace();
        if (ORDERED_LIST.equals(parentListType) || UNORDERED_LIST.equals(parentListType)) {
            frag.append("<li");
            if (namespace != null) {
                frag.append(" xmlns=\"").append(namespace).append("\"");
            }
            frag.append(">");
        } else if (DEFINITION_LIST.equals(parentListType)) {
            frag.append("<dt");
            if (namespace != null) {
                frag.append(" xmlns=\"").append(namespace).append("\"");
            }
            frag.append("/>");
            frag.append("<dd");
            if (namespace != null) {
                frag.append(" xmlns=\"").append(namespace).append("\"");
            }
            frag.append(">");
        }
        if (ORDERED_LIST.equals(listType)) {
            frag.append("<ol");
        } else if (UNORDERED_LIST.equals(listType)) {
            frag.append("<ul");
        } else {
            frag.append("<dl");
        }
        if (namespace != null) {
            frag.append(" xmlns=\"").append(namespace).append("\"");
        }
        frag.append(">");
        if (ORDERED_LIST.equals(listType) || UNORDERED_LIST.equals(listType)) {
            frag.append("<li/>");
        } else {
            frag.append("<dt/><dd/>");
        }
        if (ORDERED_LIST.equals(listType)) {
            frag.append("</ol>");
        } else if (UNORDERED_LIST.equals(listType)) {
            frag.append("</ul>");
        } else {
            frag.append("</dl>");
        }
        if (ORDERED_LIST.equals(parentListType) || UNORDERED_LIST.equals(parentListType)) {
            frag.append("</li>");
        } else if (DEFINITION_LIST.equals(parentListType)) {
            frag.append("</dd>");
        }
        return frag.toString();
    }

    @Override
    protected StringBuilder getListXMLFragment(String listType, Map<String, String> attributes, int numberOfListItems, AuthorAccess authorAccess) {
        StringBuilder frag = new StringBuilder();
        if (ORDERED_LIST.equals(listType)) {
            frag.append("<ol");
        } else if (UNORDERED_LIST.equals(listType)) {
            frag.append("<ul");
        } else {
            frag.append("<dl");
        }
        frag.append(" xmlns=\"").append(this.getNamespace());
        frag.append(CommonsOperationsUtil.serializeAttributes(attributes, Collections.singleton("xmlns")));
        frag.append("\">");
        for (int i = 0; i < numberOfListItems; ++i) {
            if (ORDERED_LIST.equals(listType) || UNORDERED_LIST.equals(listType)) {
                frag.append("<li/>");
                continue;
            }
            frag.append("<dt/><dd/>");
        }
        if (ORDERED_LIST.equals(listType)) {
            frag.append("</ol>");
        } else if (UNORDERED_LIST.equals(listType)) {
            frag.append("</ul>");
        } else {
            frag.append("</dl>");
        }
        return frag;
    }

    @Override
    protected CommonsOperationsUtil.ConversionElementHelper getConversionElementsChecker() {
        return new CommonsOperationsUtil.ConversionElementHelper(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
                boolean treatAsBlockToConvert = false;
                if (!(node instanceof AuthorElement)) throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("list.convert.exception"));
                AuthorElement element = (AuthorElement)node;
                String name = element.getLocalName();
                if (name == null) return treatAsBlockToConvert;
                boolean childOfList = false;
                if ("ul".equals(name) || "ol".equals(name) || "p".equals(name) || "dd".equals(name)) {
                    for (AuthorNode parent = element.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof AuthorElement)) continue;
                        if ("dl".equals(((AuthorElement)parent).getLocalName())) return false;
                        if (!"dd".equals(((AuthorElement)parent).getLocalName())) continue;
                        return false;
                    }
                    if (childOfList) return false;
                    return true;
                }
                if ("p".equals(name)) return true;
                if ("li".equals(name)) return true;
                if ("ul".equals(name)) return true;
                if ("ol".equals(name)) return true;
                if ("dl".equals(name)) return true;
                if (!"dt".equals(name)) throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("list.convert.exception"));
                return true;
            }

            @Override
            public AuthorDocumentFragment createAuthorDocumentFragment(AuthorDocumentController controller, int start, int end) throws AuthorOperationException, BadLocationException {
                AuthorDocumentFragment fragment = null;
                OffsetInformation info = controller.getContentInformationAtOffset(start);
                if (info.getPositionType() == 1 || start == info.getNodeForOffset().getStartOffset() + 1) {
                    AuthorNode node = info.getNodeForMarkerOffset();
                    if (node == null) {
                        node = info.getNodeForOffset();
                    }
                    if (node instanceof AuthorElement && "dt".equals(((AuthorElement)node).getLocalName())) {
                        Styles styles;
                        String display;
                        boolean isBlock;
                        String newFrag;
                        AuthorNode nextNode;
                        StringBuilder contentBuilder = new StringBuilder();
                        String dtFrag = XHTMLInsertListOperation.computeFragment(node, true, controller);
                        if (dtFrag != null) {
                            contentBuilder.append(dtFrag);
                        }
                        if ((nextNode = controller.getNodeAtOffset(node.getEndOffset() + 2)) instanceof AuthorElement && "dd".equals(((AuthorElement)nextNode).getLocalName()) && (newFrag = XHTMLInsertListOperation.computeFragment(nextNode, isBlock = "block".equals(display = (styles = XHTMLInsertListOperation.this.authorAccess.getEditorAccess().getStyles(nextNode)).getDisplay()) || "list-item".equals(display), controller)) != null) {
                            if (contentBuilder.length() > 0) {
                                contentBuilder.append(" - ");
                            }
                            contentBuilder.append(newFrag);
                        }
                        fragment = controller.createNewDocumentFragmentInContext(contentBuilder.toString(), node.getStartOffset());
                    } else if (node instanceof AuthorElement && "dd".equals(((AuthorElement)node).getLocalName())) {
                        fragment = controller.createNewDocumentFragmentInContext("", node.getStartOffset());
                    }
                }
                return fragment;
            }
        };
    }

    private static String computeFragment(AuthorNode node, boolean isBlock, AuthorDocumentController controller) throws BadLocationException, AuthorOperationException {
        String frag = null;
        int so = node.getStartOffset();
        int eo = node.getEndOffset();
        AuthorDocumentFragment docFrag = null;
        if (so + 1 == eo) {
            docFrag = controller.createNewDocumentTextFragment("");
        } else if (isBlock) {
            docFrag = controller.createDocumentFragment(++so, --eo);
        }
        frag = controller.serializeFragmentToXML(docFrag);
        return frag;
    }

    @Override
    protected String getParentListType(AuthorNode node) {
        while (node != null) {
            if (node instanceof AuthorElement) {
                String localName = ((AuthorElement)node).getLocalName();
                if ("li".equals(localName)) {
                    return null;
                }
                if ("dd".equals(localName)) {
                    return null;
                }
                if ("ol".equals(localName)) {
                    return ORDERED_LIST;
                }
                if ("ul".equals(localName)) {
                    return UNORDERED_LIST;
                }
                if ("dl".equals(localName)) {
                    return DEFINITION_LIST;
                }
            }
            node = node.getParent();
        }
        return null;
    }

    @Override
    protected boolean isListElement(AuthorNode node) {
        boolean toRet = false;
        if (node instanceof AuthorElement) {
            String localName = ((AuthorElement)node).getLocalName();
            String parentLocalName = ((AuthorElement)node).getParentElement().getLocalName();
            ImmutableSet listElementNames = ImmutableSet.of((Object)"ul", (Object)"ol", (Object)"li", (Object)"dl", (Object)"dd", (Object)"dt", (Object[])new String[0]);
            toRet = listElementNames.contains(localName) || listElementNames.contains(parentLocalName);
        }
        return toRet;
    }

    @Override
    protected boolean isList(AuthorNode node) {
        boolean toRet = false;
        if (node instanceof AuthorElement) {
            String localName = ((AuthorElement)node).getLocalName();
            toRet = LIST_ELEMENTS.contains(localName);
        }
        return toRet;
    }

    @Override
    protected String getListTypeDescription(String listType) {
        String toRet = "";
        if (ORDERED_LIST.equals(listType)) {
            toRet = "ordered";
        } else if (UNORDERED_LIST.equals(listType)) {
            toRet = "unordered";
        } else if (DEFINITION_LIST.equals(listType)) {
            toRet = "definition";
        }
        return toRet;
    }
}

