/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.SchemaManagerFilter;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorImageDecorator;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProvider;
import ro.sync.ecss.extensions.api.EditPropertiesHandler;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.UniqueAttributesRecognizer;
import ro.sync.ecss.extensions.api.XHTMLAuthorActionEventHandler;
import ro.sync.ecss.extensions.api.content.ClipboardFragmentProcessor;
import ro.sync.ecss.extensions.api.link.CannotRecognizeIDException;
import ro.sync.ecss.extensions.api.link.ElementLocatorProvider;
import ro.sync.ecss.extensions.api.link.IDTypeIdentifier;
import ro.sync.ecss.extensions.api.link.IDTypeRecognizer;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableOperationsHandler;
import ro.sync.ecss.extensions.commons.table.support.HTMLTableCellInfoProvider;
import ro.sync.ecss.extensions.xhtml.XHTMLAuthorImageDecorator;
import ro.sync.ecss.extensions.xhtml.XHTMLAuthorTableOperationsHandler;
import ro.sync.ecss.extensions.xhtml.XHTMLElementLocatorProvider;
import ro.sync.ecss.extensions.xhtml.XHTMLExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.xhtml.XHTMLNodeRendererCustomizer;
import ro.sync.ecss.extensions.xhtml.XHTMLSchemaManagerFilter;
import ro.sync.ecss.extensions.xhtml.id.XHTMLUniqueAttributesRecognizer;
import ro.sync.ecss.extensions.xhtml.imagemap.EditImageMapOperation;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLExtensionsBundle
extends ExtensionsBundle {
    private static final Logger logger = LoggerFactory.getLogger((String)XHTMLExtensionsBundle.class.getName());
    private XHTMLAuthorTableOperationsHandler xhtmlAuthorTableOperationsHandler;
    private XHTMLUniqueAttributesRecognizer uniqueAttributesRecognizer;
    private AuthorActionEventHandler handler;
    private XHTMLAuthorImageDecorator decorator;

    public AuthorExtensionStateListener createAuthorExtensionStateListener() {
        this.uniqueAttributesRecognizer = new XHTMLUniqueAttributesRecognizer();
        return this.uniqueAttributesRecognizer;
    }

    public AuthorTableCellSpanProvider createAuthorTableCellSpanProvider() {
        return new HTMLTableCellInfoProvider();
    }

    public AuthorTableColumnWidthProvider createAuthorTableColumnWidthProvider() {
        return new HTMLTableCellInfoProvider();
    }

    public String getDescription() {
        return "XHTML extensions bundle implementation";
    }

    public String getDocumentTypeID() {
        return "XHTML.document.type";
    }

    public UniqueAttributesRecognizer getUniqueAttributesIdentifier() {
        return this.uniqueAttributesRecognizer;
    }

    public ClipboardFragmentProcessor getClipboardFragmentProcessor() {
        return this.uniqueAttributesRecognizer;
    }

    public ElementLocatorProvider createElementLocatorProvider() {
        return new XHTMLElementLocatorProvider();
    }

    public AuthorExternalObjectInsertionHandler createExternalObjectInsertionHandler() {
        return new XHTMLExternalObjectInsertionHandler();
    }

    public SchemaManagerFilter createSchemaManagerFilter() {
        return new XHTMLSchemaManagerFilter();
    }

    public XMLNodeRendererCustomizer createXMLNodeCustomizer() {
        return new XHTMLNodeRendererCustomizer();
    }

    public AuthorTableOperationsHandler getAuthorTableOperationsHandler() {
        if (this.xhtmlAuthorTableOperationsHandler == null) {
            this.xhtmlAuthorTableOperationsHandler = new XHTMLAuthorTableOperationsHandler();
        }
        return this.xhtmlAuthorTableOperationsHandler;
    }

    public IDTypeRecognizer createIDTypeRecognizer() {
        return new IDTypeRecognizer(){

            public int[] locateIDType(String systemID, Context context, String attrName, String attrNs, String attributeValue, IDTypeIdentifier idIdentifier, short mode) {
                return null;
            }

            public boolean isIDTypeRecognitionAvailable() {
                return false;
            }

            public boolean isDefaultIDTypeRecognitionAvailable() {
                return false;
            }

            public List<IDTypeIdentifier> detectIDType(String systemID, Context context, String attrName, String attrNs, String attributeValue, int offset) throws CannotRecognizeIDException {
                return null;
            }
        };
    }

    public AuthorActionEventHandler getAuthorActionEventHandler() {
        if (this.handler == null) {
            this.handler = new XHTMLAuthorActionEventHandler();
        }
        return this.handler;
    }

    public AuthorImageDecorator getAuthorImageDecorator() {
        if (this.decorator == null) {
            this.decorator = new XHTMLAuthorImageDecorator();
        }
        return this.decorator;
    }

    public EditPropertiesHandler createEditPropertiesHandler() {
        return new EditPropertiesHandler(){

            public String getDescription() {
                return "Handles imagemap editing";
            }

            public void editProperties(AuthorNode authorNode, AuthorAccess authorAccess) {
                try {
                    new EditImageMapOperation().doOperation(authorAccess, null);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }

            public boolean canEditProperties(AuthorNode authorNode) {
                boolean isHandled = false;
                if (authorNode.getType() == 0) {
                    AuthorElement element = (AuthorElement)authorNode;
                    if ("img".equals(element.getLocalName())) {
                        AttrValue useMapAttr = element.getAttribute("usemap");
                        if (useMapAttr != null && useMapAttr.getValue().startsWith("#")) {
                            isHandled = XHTMLExtensionsBundle.hasASibling(element, "map", new String[]{"name", "id"}, useMapAttr.getValue().substring(1));
                        }
                    } else if ("map".equals(element.getLocalName())) {
                        AttrValue mapNameOrIDAttr = element.getAttribute("name");
                        if (mapNameOrIDAttr == null) {
                            mapNameOrIDAttr = element.getAttribute("id");
                        }
                        if (mapNameOrIDAttr != null) {
                            isHandled = XHTMLExtensionsBundle.hasASibling(element, "img", new String[]{"usemap"}, "#" + mapNameOrIDAttr.getValue());
                        }
                    }
                }
                return isHandled;
            }
        };
    }

    private static boolean hasASibling(AuthorElement element, String siblingName, String[] siblingAttributes, String siblingAttrValue) {
        AuthorElement[] elementsByLocalName;
        AuthorElement parent = (AuthorElement)element.getParentElement();
        if (parent != null && (elementsByLocalName = parent.getElementsByLocalName(siblingName)) != null) {
            for (AuthorElement brotherElement : elementsByLocalName) {
                for (String attr : siblingAttributes) {
                    AttrValue attrValue = brotherElement.getAttribute(attr);
                    if (attrValue == null || !siblingAttrValue.equals(attrValue.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getHelpPageID(String currentEditorPage) {
        return "author-xhtml-doc-type";
    }
}

