/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.commons.MediaFileChooser;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertMediaOperation
implements AuthorOperation {
    public static final String ARGUMENT_MEDIA_URL = "mediaUrl";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("mediaUrl", 0, "The URL of the media. If not defined, an file chooser will be shown.")};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object mediaUrl = args.getArgumentValue(ARGUMENT_MEDIA_URL);
        String ref = null;
        ref = mediaUrl instanceof String ? MediaFileChooser.makeUrlRelative(authorAccess, (String)mediaUrl) : MediaFileChooser.chooseMediaFile(authorAccess);
        if (ref != null) {
            authorAccess.getDocumentController().insertXMLFragmentSchemaAware(InsertMediaOperation.createMediaContentToInsert(ref).toString(), authorAccess.getEditorAccess().getCaretOffset());
        }
    }

    public static StringBuilder createMediaContentToInsert(String ref) {
        ref = MediaObjectsUtil.correctMediaEmbeddedReference(ref);
        String type = "iframe ";
        if (MediaObjectsUtil.isAudioReference(ref)) {
            type = "audio controls=\"controls\"";
        } else if (MediaObjectsUtil.isVideoReference(ref)) {
            type = "video controls=\"controls\"";
        }
        return new StringBuilder().append("<").append(type).append(" xmlns=\"http://www.w3.org/1999/xhtml\" src=\"").append(ref).append("\"/>");
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }

    public String getDescription() {
        return "Insert a XHTML media object";
    }
}

