/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.CALSAndHTMLTableLayoutProblem;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class HTMLTableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider {
    private static final String ELEMENT_NAME_COLGROUP = "colgroup";
    private static final String ELEMENT_NAME_COL = "col";
    private static final String ELEMENT_NAME_THEAD = "thead";
    private static final String ELEMENT_NAME_TFOOT = "tfoot";
    private static final String ELEMENT_NAME_TBODY = "tbody";
    public static final String ATTR_NAME_SPAN = "span";
    private static final String ATTR_NAME_WIDTH = "width";
    private static final String ATTR_NAME_ALIGN = "align";
    private static final String HTML_CELL_NAME = "td";
    private static final String HTML_ROW_NAME = "tr";
    private static final String HTML_HEADER_CELL_NAME = "th";
    private static final Logger logger = LoggerFactory.getLogger((String)HTMLTableCellInfoProvider.class.getName());
    private List<WidthRepresentation> colWidthSpecs = new ArrayList<WidthRepresentation>();
    private Map<WidthRepresentation, AuthorElement> widthRepresentationsToElementsMap = new HashMap<WidthRepresentation, AuthorElement>();
    private AuthorElement tableElement;

    public Integer getColSpan(AuthorElement cellElement) {
        Integer colspan;
        block3: {
            colspan = null;
            AttrValue attrValue = cellElement.getAttribute("colspan");
            if (attrValue != null) {
                try {
                    int value = NumberParserUtil.parseInt((String)attrValue.getValue());
                    colspan = Math.max(value, 1);
                }
                catch (NumberFormatException nfe) {
                    if (this.errorsListener == null) break block3;
                    this.errorsListener.add(cellElement, this.tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, attrValue.getValue(), "colspan");
                }
            }
        }
        return colspan;
    }

    public Integer getRowSpan(AuthorElement cellElement) {
        Integer rowspan;
        block3: {
            rowspan = null;
            AttrValue attrValue = cellElement.getAttribute("rowspan");
            if (attrValue != null) {
                try {
                    int value = NumberParserUtil.parseInt((String)attrValue.getValue());
                    rowspan = Math.max(value, 1);
                }
                catch (NumberFormatException nfe) {
                    if (this.errorsListener == null) break block3;
                    this.errorsListener.add(cellElement, this.tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, attrValue.getValue(), "rowspan");
                }
            }
        }
        return rowspan;
    }

    public void init(AuthorElement tableElement) {
        block27: {
            block26: {
                this.tableElement = tableElement;
                AuthorElement[] colGroupChildren = HTMLTableCellInfoProvider.getElementsByLocalName(tableElement, ELEMENT_NAME_COLGROUP);
                if (colGroupChildren == null || colGroupChildren.length <= 0) break block26;
                for (int i = 0; i < colGroupChildren.length; ++i) {
                    int colgroupSpan;
                    AttrValue attrValue;
                    AuthorElement child;
                    block23: {
                        child = colGroupChildren[i];
                        attrValue = child.getAttribute(ATTR_NAME_SPAN);
                        colgroupSpan = 1;
                        if (attrValue != null) {
                            try {
                                colgroupSpan = NumberParserUtil.parseInt((String)attrValue.getValue());
                            }
                            catch (NumberFormatException e) {
                                logger.debug((Object)e, (Throwable)e);
                                if (this.errorsListener == null) break block23;
                                this.errorsListener.add(child, tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, attrValue.getValue(), ATTR_NAME_SPAN);
                            }
                        }
                    }
                    attrValue = child.getAttribute(ATTR_NAME_WIDTH);
                    String colgroupWidth = null;
                    if (attrValue != null) {
                        colgroupWidth = attrValue.getValue();
                    }
                    String cgAlignValue = null;
                    attrValue = child.getAttribute(ATTR_NAME_ALIGN);
                    if (attrValue != null) {
                        cgAlignValue = attrValue.getValue();
                    }
                    List colgroupChildren = child.getContentNodes();
                    for (AuthorNode cgChildNode : colgroupChildren) {
                        int colSpan;
                        String alignValue;
                        String colWidth;
                        AuthorElement cgChild;
                        block24: {
                            if (!(cgChildNode instanceof AuthorElement) || !ELEMENT_NAME_COL.equalsIgnoreCase((cgChild = (AuthorElement)cgChildNode).getLocalName())) continue;
                            colgroupSpan = -1;
                            AttrValue colWidthAttribute = cgChild.getAttribute(ATTR_NAME_WIDTH);
                            colWidth = null;
                            if (colWidthAttribute != null) {
                                colWidth = colWidthAttribute.getValue();
                            } else if (colgroupWidth != null) {
                                colWidth = colgroupWidth;
                            }
                            alignValue = cgAlignValue;
                            attrValue = cgChild.getAttribute(ATTR_NAME_ALIGN);
                            if (attrValue != null) {
                                alignValue = attrValue.getValue();
                            }
                            AttrValue colSpanAttribute = cgChild.getAttribute(ATTR_NAME_SPAN);
                            colSpan = 1;
                            if (colSpanAttribute != null) {
                                try {
                                    colSpan = NumberParserUtil.parseInt((String)colSpanAttribute.getValue());
                                }
                                catch (NumberFormatException e) {
                                    logger.debug((Object)e, (Throwable)e);
                                    if (this.errorsListener == null) break block24;
                                    this.errorsListener.add(cgChild, tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, ATTR_NAME_SPAN, colSpanAttribute.getValue());
                                }
                            }
                        }
                        for (int j = 0; j < colSpan; ++j) {
                            WidthRepresentation widthRepresentation = new WidthRepresentation(colWidth, true);
                            widthRepresentation.setAlign(alignValue);
                            this.colWidthSpecs.add(widthRepresentation);
                            this.widthRepresentationsToElementsMap.put(widthRepresentation, cgChild);
                        }
                    }
                    if (colgroupSpan <= 0) continue;
                    for (int j = 0; j < colgroupSpan; ++j) {
                        WidthRepresentation widthRepresentation = new WidthRepresentation(colgroupWidth, true);
                        widthRepresentation.setAlign(cgAlignValue);
                        this.colWidthSpecs.add(widthRepresentation);
                    }
                }
                break block27;
            }
            AuthorElement[] colChildren = HTMLTableCellInfoProvider.getElementsByLocalName(tableElement, ELEMENT_NAME_COL);
            if (colChildren == null || colChildren.length <= 0) break block27;
            for (int i = 0; i < colChildren.length; ++i) {
                int colSpan;
                String textAlignValue;
                String colWidth;
                AuthorElement colChild;
                block25: {
                    colChild = colChildren[i];
                    AttrValue colWidthAttribute = colChild.getAttribute(ATTR_NAME_WIDTH);
                    colWidth = null;
                    if (colWidthAttribute != null) {
                        colWidth = colWidthAttribute.getValue();
                    }
                    textAlignValue = null;
                    AttrValue attrValue = colChild.getAttribute(ATTR_NAME_ALIGN);
                    if (attrValue != null) {
                        textAlignValue = attrValue.getValue();
                    }
                    AttrValue colSpanAttribute = colChild.getAttribute(ATTR_NAME_SPAN);
                    colSpan = 1;
                    if (colSpanAttribute != null) {
                        try {
                            colSpan = NumberParserUtil.parseInt((String)colSpanAttribute.getValue());
                        }
                        catch (NumberFormatException e) {
                            logger.debug((Object)e, (Throwable)e);
                            if (this.errorsListener == null) break block25;
                            this.errorsListener.add(colChild, tableElement, CALSAndHTMLTableLayoutProblem.ATTRIBUTE_VALUE_NOT_INTEGER, ATTR_NAME_SPAN, colSpanAttribute.getValue());
                        }
                    }
                }
                for (int j = 0; j < colSpan; ++j) {
                    WidthRepresentation widthRepresentation = new WidthRepresentation(colWidth, true);
                    widthRepresentation.setAlign(textAlignValue);
                    this.colWidthSpecs.add(widthRepresentation);
                    this.widthRepresentationsToElementsMap.put(widthRepresentation, colChild);
                }
            }
        }
    }

    private static AuthorElement[] getElementsByLocalName(AuthorElement element, String localName) {
        AuthorElement[] elems = null;
        elems = element.getLocalName().equals(element.getLocalName().toUpperCase()) ? element.getElementsByLocalName(localName.toUpperCase()) : element.getElementsByLocalName(localName);
        return elems;
    }

    public String getDescription() {
        return "Provides information about cells in HTML tables";
    }

    public boolean hasColumnSpecifications(AuthorElement tableElement) {
        return true;
    }

    public List<WidthRepresentation> getCellWidth(AuthorElement cellElement, int colNumberStart, int colSpan) {
        ArrayList<WidthRepresentation> toReturn = null;
        int size = this.colWidthSpecs.size();
        if (size >= colNumberStart && size >= colNumberStart + colSpan) {
            toReturn = new ArrayList<WidthRepresentation>(colSpan);
            for (int i = colNumberStart; i < colNumberStart + colSpan; ++i) {
                toReturn.add(this.colWidthSpecs.get(i));
            }
        }
        return toReturn;
    }

    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] colWidths, String tableCellsTagName) throws AuthorOperationException {
        if (this.isHTMLTableCellTagName(tableCellsTagName)) {
            int i;
            AuthorElement[] colGroupChildren = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_COLGROUP);
            boolean colsModifiedInDoc = false;
            if (colGroupChildren != null && colGroupChildren.length > 0) {
                colsModifiedInDoc = true;
                int colWidthsIdx = 0;
                for (i = 0; i < colGroupChildren.length; ++i) {
                    AuthorElement child = colGroupChildren[i];
                    AuthorElement[] colChildren = HTMLTableCellInfoProvider.getElementsByLocalName(child, ELEMENT_NAME_COL);
                    for (int j = 0; j < colChildren.length; ++j) {
                        int newColWidthsIdxVal;
                        AuthorElement colChild = colChildren[j];
                        if ((newColWidthsIdxVal = colWidthsIdx++) >= colWidths.length) continue;
                        WidthRepresentation widthRepresentation = colWidths[newColWidthsIdxVal];
                        authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(widthRepresentation.getWidthRepresentation()), colChild);
                    }
                }
            } else {
                AuthorElement[] colChildren = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_COL);
                if (colChildren != null && colChildren.length > 0) {
                    colsModifiedInDoc = true;
                    for (i = 0; i < colChildren.length; ++i) {
                        AuthorElement colChild = colChildren[i];
                        authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(colWidths[i].getWidthRepresentation()), colChild);
                    }
                }
            }
            if (!colsModifiedInDoc && colWidths != null && authorDocumentController != null) {
                int offset = this.getInsertColsOffset();
                if (offset == -1) {
                    throw new AuthorOperationException("No valid offset to insert the columns width specification.");
                }
                String xmlFragment = this.createXMLFragment(colWidths);
                authorDocumentController.insertXMLFragment(xmlFragment, offset);
            }
        }
    }

    private int getInsertColsOffset() {
        int toReturn = -1;
        AuthorElement[] thead = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_THEAD);
        if (thead != null && thead.length > 0) {
            toReturn = thead[0].getStartOffset();
        } else {
            AuthorElement[] tbody = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_TBODY);
            if (tbody != null && tbody.length > 0) {
                toReturn = tbody[0].getStartOffset();
            } else {
                AuthorElement[] tr = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, HTML_ROW_NAME);
                if (tr != null && tr.length > 0) {
                    toReturn = tr[0].getStartOffset();
                } else {
                    AuthorElement[] tfoot = HTMLTableCellInfoProvider.getElementsByLocalName(this.tableElement, ELEMENT_NAME_TFOOT);
                    if (tfoot != null && tfoot.length > 0) {
                        toReturn = tfoot[0].getStartOffset();
                    }
                }
            }
        }
        return toReturn;
    }

    private String createXMLFragment(WidthRepresentation[] widthRepresentations) {
        StringBuilder fragment = new StringBuilder();
        String ns = this.tableElement.getNamespace();
        for (int i = 0; i < widthRepresentations.length; ++i) {
            WidthRepresentation width = widthRepresentations[i];
            fragment.append("<col");
            String strRepresentation = width.getWidthRepresentation();
            if (strRepresentation != null) {
                fragment.append(" width=\"" + width.getWidthRepresentation() + "\"");
            }
            if (ns != null && ns.length() > 0) {
                fragment.append(" xmlns=\"" + ns + "\"");
            }
            fragment.append("/>");
        }
        return fragment.toString();
    }

    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int newTableWidth, String tableCellsTagName) throws AuthorOperationException {
        if (this.isHTMLTableCellTagName(tableCellsTagName) && newTableWidth > 0 && authorDocumentController != null) {
            if (this.tableElement != null) {
                String newWidth = String.valueOf(newTableWidth);
                authorDocumentController.setAttribute(ATTR_NAME_WIDTH, new AttrValue(newWidth), this.tableElement);
            } else {
                throw new AuthorOperationException("Cannot find the element representing the table.");
            }
        }
    }

    public WidthRepresentation getTableWidth(String tableCellsTagName) {
        WidthRepresentation toReturn = null;
        if (this.isHTMLTableCellTagName(tableCellsTagName)) {
            toReturn = this.getTableWidth();
        }
        return toReturn;
    }

    private WidthRepresentation getTableWidth() {
        String width;
        AttrValue widthAttr;
        WidthRepresentation toReturn = null;
        if (this.tableElement != null && (widthAttr = this.tableElement.getAttribute(ATTR_NAME_WIDTH)) != null && (width = widthAttr.getValue()) != null) {
            toReturn = new WidthRepresentation(width, true);
        }
        return toReturn;
    }

    public boolean isTableAcceptingWidth(String tableCellsTagName) {
        return this.isHTMLTableCellTagName(tableCellsTagName);
    }

    public boolean isTableAndColumnsResizable(String tableCellsTagName) {
        return this.isHTMLTableCellTagName(tableCellsTagName);
    }

    public boolean isAcceptingFixedColumnWidths(String tableCellsTagName) {
        return this.isHTMLTableCellTagName(tableCellsTagName);
    }

    public boolean isAcceptingPercentageColumnWidths(String tableCellsTagName) {
        return this.isHTMLTableCellTagName(tableCellsTagName);
    }

    public boolean isAcceptingProportionalColumnWidths(String tableCellsTagName) {
        return this.isHTMLTableCellTagName(tableCellsTagName);
    }

    public boolean isHTMLTableCellTagName(String tableCellsTagName) {
        return HTML_CELL_NAME.equalsIgnoreCase(tableCellsTagName) || HTML_HEADER_CELL_NAME.equalsIgnoreCase(tableCellsTagName);
    }

    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        return this.colWidthSpecs.isEmpty() ? null : this.colWidthSpecs;
    }

    public AuthorElement getColSpec(int columnIndex) {
        if (this.colWidthSpecs != null && this.colWidthSpecs.size() > columnIndex) {
            return this.widthRepresentationsToElementsMap.get(this.colWidthSpecs.get(columnIndex));
        }
        return null;
    }

    public boolean isPreferPercentageColumnWidths(String tableCellsTagName) {
        return this.isHTMLTableCellTagName(tableCellsTagName);
    }
}

