/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.awt.Frame;
import java.text.Collator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.ECSortCustomizerDialog;
import ro.sync.ecss.extensions.commons.sort.SASortCustomizerDialog;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.SortUtil;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SortOperation
implements AuthorOperation {
    private static final String SORTING_SUPPORT_PAGE_ID = "sorting-support";
    private static final Logger logger = LoggerFactory.getLogger((String)SortOperation.class.getName());
    protected static final String COLUMN = "Column";
    protected AuthorAccess authorAccess;
    private SortCriteriaInformation sortInformation = null;
    private final String selElementsString;
    private final String allElementsString;

    public SortOperation(String selElementsString, String allElementsString) {
        this.selElementsString = selElementsString;
        this.allElementsString = allElementsString;
    }

    public String getDescription() {
        return "Sort operation";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        block14: {
            this.authorAccess = authorAccess;
            try {
                List<CriterionInformation> sortCriteria;
                AuthorElement parent;
                int offset = authorAccess.getEditorAccess().getCaretOffset();
                List selectionIntervals = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
                if (selectionIntervals != null && !selectionIntervals.isEmpty()) {
                    offset = ((ContentInterval)selectionIntervals.get(0)).getStartOffset();
                }
                if ((parent = this.getSortParent(offset, authorAccess)) == null || (sortCriteria = this.getSortCriteria(parent)).isEmpty()) break block14;
                int[] selectedNonIgnoredChildrenInterval = this.getSelectedNonIgnoredChildrenInterval(parent);
                this.sortInformation = this.getSortInformation(authorAccess, parent, sortCriteria, selectedNonIgnoredChildrenInterval);
                if (this.sortInformation == null || this.sortInformation.criteriaInfo == null || this.sortInformation.criteriaInfo.length <= 0) break block14;
                Locale locale = Locale.getDefault();
                String langVal = SortUtil.detectXMLLangFrom((AuthorNode)parent);
                if (langVal != null) {
                    locale = SortOperation.createLocale(langVal);
                }
                AuthorOperationException[] error = new AuthorOperationException[1];
                TreeSet<SortableFragment> sortableNodesFragments = new TreeSet<SortableFragment>(this.createNodesComparator(locale, error));
                int i = 0;
                int indexInSortableNodes = 0;
                List contentNodes = parent.getContentNodes();
                ArrayList<AuthorDocumentFragment> ignoredNodesFragments = new ArrayList<AuthorDocumentFragment>();
                ArrayList<Integer> ignoredNodesIndices = new ArrayList<Integer>();
                for (AuthorNode child : contentNodes) {
                    try {
                        if (this.isIgnored(child) || this.sortInformation.onlySelectedElements && selectedNonIgnoredChildrenInterval != null && (selectedNonIgnoredChildrenInterval[0] > indexInSortableNodes || selectedNonIgnoredChildrenInterval[1] < indexInSortableNodes)) {
                            ignoredNodesFragments.add(authorAccess.getDocumentController().createDocumentFragment(child, true));
                            ignoredNodesIndices.add(i);
                        } else {
                            SortableFragment sortableFragment = new SortableFragment();
                            sortableFragment.documentFragment = authorAccess.getDocumentController().createDocumentFragment(child, true);
                            sortableFragment.keyValues = this.getSortKeysValues(child, this.sortInformation);
                            sortableNodesFragments.add(sortableFragment);
                            if (error[0] != null) {
                                throw error[0];
                            }
                        }
                    }
                    catch (BadLocationException e) {
                        logger.error((Object)e, (Throwable)e);
                        throw new AuthorOperationException(e.getMessage(), (Throwable)e);
                    }
                    if (!this.isIgnored(child)) {
                        ++indexInSortableNodes;
                    }
                    ++i;
                }
                AuthorDocumentFragment[] newFragments = new AuthorDocumentFragment[sortableNodesFragments.size() + ignoredNodesFragments.size()];
                int[] insertOffsets = new int[newFragments.length];
                Iterator fragmentsIt = ignoredNodesFragments.iterator();
                Iterator iterator = ignoredNodesIndices.iterator();
                while (iterator.hasNext() && fragmentsIt.hasNext()) {
                    int index = (Integer)iterator.next();
                    newFragments[index] = (AuthorDocumentFragment)fragmentsIt.next();
                }
                insertOffsets[0] = parent.getStartOffset() + 1;
                Iterator it = sortableNodesFragments.iterator();
                for (int j = 0; j < newFragments.length; ++j) {
                    if (newFragments[j] == null && it.hasNext()) {
                        AuthorDocumentFragment documentFragment;
                        newFragments[j] = documentFragment = ((SortableFragment)it.next()).documentFragment;
                    }
                    if (j <= 0) continue;
                    insertOffsets[j] = parent.getStartOffset() + 1;
                }
                authorAccess.getDocumentController().multipleDelete(parent, new int[]{parent.getStartOffset() + 1}, new int[]{parent.getEndOffset()});
                authorAccess.getDocumentController().insertMultipleFragments(parent, newFragments, insertOffsets);
                authorAccess.getEditorAccess().setCaretPosition(offset);
            }
            catch (AuthorOperationException e) {
                authorAccess.getWorkspaceAccess().showErrorMessage("The sort operation couldn't be performed.\n" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private SortCriteriaInformation getSortInformation(AuthorAccess authorAccess, AuthorElement parent, List<CriterionInformation> sortCriteria, int[] selectedNonIgnoredChildrenInterval) throws AuthorOperationException {
        this.canBeSorted(parent, selectedNonIgnoredChildrenInterval);
        SortCriteriaInformation sortInfo = null;
        boolean cannotSortAllElements = false;
        try {
            this.canBeSorted(parent, new int[]{0, this.getNonIgnoredChildren(parent).size() - 1});
        }
        catch (AuthorOperationException e) {
            cannotSortAllElements = true;
        }
        Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
        if (Platform.STANDALONE == platform) {
            SASortCustomizerDialog saSortCustomizerDialog = new SASortCustomizerDialog((Frame)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), authorAccess.getAuthorResourceBundle().getMessage(this.selElementsString), authorAccess.getAuthorResourceBundle().getMessage(this.allElementsString)){

                public String getHelpPageID() {
                    return SortOperation.this.getHelpPageID();
                }
            };
            sortInfo = saSortCustomizerDialog.getSortInformation(sortCriteria, selectedNonIgnoredChildrenInterval != null, cannotSortAllElements);
        } else if (Platform.ECLIPSE == platform) {
            sortInfo = new ECSortCustomizerDialog((Shell)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), authorAccess.getAuthorResourceBundle().getMessage(this.selElementsString), authorAccess.getAuthorResourceBundle().getMessage(this.allElementsString), this.getHelpPageID()).getSortInformation(sortCriteria, selectedNonIgnoredChildrenInterval != null, cannotSortAllElements);
        }
        return sortInfo;
    }

    private Comparator<SortableFragment> createNodesComparator(final Locale locale, final AuthorOperationException[] error) {
        return new Comparator<SortableFragment>(){

            @Override
            public int compare(SortableFragment s1, SortableFragment s2) {
                for (int j = 0; s1.keyValues != null && s2.keyValues != null && j < s1.keyValues.length; ++j) {
                    if (s1.keyValues[j] == null && s2.keyValues[j] != null) {
                        return CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[j].getOrder()) ? 1 : -1;
                    }
                    if (s2.keyValues[j] == null) {
                        return CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[j].getOrder()) ? -1 : 1;
                    }
                    if (s1.keyValues[j].trim().equals(s2.keyValues[j].trim())) continue;
                    int compareTo = 0;
                    s1.keyValues[j] = s1.keyValues[j].trim();
                    s2.keyValues[j] = s2.keyValues[j].trim();
                    if (CriterionInformation.TYPE.NUMERIC.getName().equals(SortOperation.this.sortInformation.criteriaInfo[j].getType())) {
                        Double val1 = SortUtil.parseNumber(error, s1.keyValues[j]);
                        if (error[0] == null) {
                            Double val2 = SortUtil.parseNumber(error, s2.keyValues[j]);
                            if (error[0] == null) {
                                compareTo = CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[j].getOrder()) ? val1.compareTo(val2) : val2.compareTo(val1);
                            }
                        }
                    } else if (CriterionInformation.TYPE.DATE.getName().equals(SortOperation.this.sortInformation.criteriaInfo[j].getType())) {
                        int[] styles = new int[]{2, 3, 2, 1, 0};
                        Date val1 = null;
                        Date val2 = null;
                        for (int k = 0; k < styles.length && (val1 == null || val2 == null); ++k) {
                            int currentStyle = styles[k];
                            Locale defaultLocale = Locale.getDefault();
                            DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(currentStyle, currentStyle, defaultLocale);
                            DateFormat dateFormatter = DateFormat.getDateInstance(currentStyle, defaultLocale);
                            DateFormat timeFormatter = DateFormat.getTimeInstance(currentStyle, defaultLocale);
                            if (val1 == null) {
                                val1 = SortUtil.parseDate(error, s1.keyValues[j], dateTimeFormatter, dateFormatter, timeFormatter);
                            }
                            if (val2 != null) continue;
                            val2 = SortUtil.parseDate(error, s2.keyValues[j], dateTimeFormatter, dateFormatter, timeFormatter);
                        }
                        if (val1 == null) {
                            val1 = SortUtil.parseXsdDatetime(error, s1.keyValues[j]);
                        }
                        if (val2 == null) {
                            val2 = SortUtil.parseXsdDatetime(error, s2.keyValues[j]);
                        }
                        if (val1 != null && val2 != null) {
                            compareTo = CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[j].getOrder()) ? val1.compareTo(val2) : val2.compareTo(val1);
                            error[0] = null;
                        }
                    } else {
                        Collator collator = Collator.getInstance(locale);
                        collator.setStrength(2);
                        collator.setDecomposition(2);
                        int result = collator.compare(s1.keyValues[j], s2.keyValues[j]);
                        int n = compareTo = CriterionInformation.ORDER.ASCENDING.getName().equals(SortOperation.this.sortInformation.criteriaInfo[j].getOrder()) ? result : -result;
                    }
                    if (error[0] != null) break;
                    if (compareTo == 0) continue;
                    return compareTo;
                }
                return 1;
            }
        };
    }

    private static Locale createLocale(String langVal) {
        int dashIdx = langVal.indexOf(45);
        String lang = langVal;
        String country = "";
        if (dashIdx > 0) {
            lang = langVal.substring(0, dashIdx);
            String[] isoLanguages = Locale.getISOLanguages();
            for (int i = 0; i < isoLanguages.length; ++i) {
                if (!isoLanguages[i].equalsIgnoreCase(lang)) continue;
                lang = isoLanguages[i];
            }
            country = langVal.substring(dashIdx + 1);
            String[] isoCountries = Locale.getISOCountries();
            for (int i = 0; i < isoCountries.length; ++i) {
                if (!isoCountries[i].equalsIgnoreCase(lang)) continue;
                country = isoCountries[i];
            }
        }
        return new Locale(lang, country);
    }

    public abstract void canBeSorted(AuthorElement var1, int[] var2) throws AuthorOperationException;

    public int[] getSelectedNonIgnoredChildrenInterval(AuthorElement parent) {
        int[] selectedChildrenInterval = null;
        if (this.authorAccess.getEditorAccess().hasSelection()) {
            if (this.forceSortAll()) {
                return null;
            }
            List selectionIntervals = this.authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            int selStart = 0;
            int selEnd = -1;
            List<AuthorNode> nonIgnoredChildren = this.getNonIgnoredChildren(parent);
            boolean validSel = true;
            for (int i = 0; i < selectionIntervals.size(); ++i) {
                ContentInterval selectionInterval = (ContentInterval)selectionIntervals.get(i);
                int[] selection = SortOperation.getSelectionElementsIndices(nonIgnoredChildren, selectionInterval.getStartOffset(), selectionInterval.getEndOffset());
                if (i == 0) {
                    selStart = selection[0];
                    selEnd = selection[1];
                    continue;
                }
                if (selection[0] - 1 == selEnd) {
                    selEnd = selection[1];
                    continue;
                }
                validSel = false;
                break;
            }
            if (validSel) {
                selectedChildrenInterval = new int[]{selStart, selEnd};
            }
        }
        return selectedChildrenInterval;
    }

    protected boolean forceSortAll() {
        return false;
    }

    private static int[] getSelectionElementsIndices(List<AuthorNode> nonIgnoredChildren, int selStart, int selEnd) {
        int startSelChildIndex = -1;
        int endSelChildIndex = -1;
        int size = nonIgnoredChildren.size();
        for (int i = 0; i < size; ++i) {
            AuthorNode authorNode = nonIgnoredChildren.get(i);
            if (authorNode.getStartOffset() <= selStart && authorNode.getEndOffset() >= selStart || startSelChildIndex == -1 && selStart <= authorNode.getStartOffset() && selEnd > authorNode.getStartOffset()) {
                startSelChildIndex = i;
            }
            if ((authorNode.getStartOffset() >= selEnd || authorNode.getEndOffset() < selEnd) && (selStart > authorNode.getEndOffset() || selEnd <= authorNode.getEndOffset())) continue;
            endSelChildIndex = i;
        }
        return new int[]{startSelChildIndex, endSelChildIndex};
    }

    protected List<AuthorNode> getNonIgnoredChildren(AuthorElement parent) {
        ExtensionsBundle extensionsBundle = this.authorAccess.getEditorAccess().getExtensionsBundle();
        if (extensionsBundle != null) {
            parent = (AuthorElement)CommonAccess.getContentReferencedNode((ExtensionsBundle)extensionsBundle, (AuthorNode)parent);
        }
        ArrayList<AuthorNode> nonIgnoredChildren = new ArrayList<AuthorNode>();
        List children = parent.getContentNodes();
        for (int i = 0; i < children.size(); ++i) {
            AuthorNode child = (AuthorNode)children.get(i);
            if (this.isIgnored(child)) continue;
            nonIgnoredChildren.add(child);
        }
        return nonIgnoredChildren;
    }

    public abstract AuthorElement getSortParent(int var1, AuthorAccess var2) throws AuthorOperationException;

    public abstract boolean isIgnored(AuthorNode var1);

    public abstract String[] getSortKeysValues(AuthorNode var1, SortCriteriaInformation var2) throws AuthorOperationException;

    public abstract List<CriterionInformation> getSortCriteria(AuthorElement var1) throws AuthorOperationException;

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected String getTextContentToSort(AuthorNode node) {
        TextContentIterator contentIterator = this.authorAccess.getDocumentController().getTextContentIterator(node.getStartOffset(), node.getEndOffset());
        StringBuilder val = new StringBuilder();
        while (contentIterator.hasNext()) {
            TextContext textContext = contentIterator.next();
            if (textContext.getEditableState() == 2) continue;
            val.append(textContext.getText());
        }
        return val.toString().trim();
    }

    protected String getHelpPageID() {
        return SORTING_SUPPORT_PAGE_ID;
    }

    private static class SortableFragment {
        private AuthorDocumentFragment documentFragment;
        private String[] keyValues;

        private SortableFragment() {
        }
    }
}

