/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public abstract class ConvertHexToCharOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)ConvertHexToCharOperation.class.getName());
    private static final int MAX_NUMBER_OF_HEX_DIGITS_TO_CONVERT = 4;

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        int len;
        boolean validSelection = true;
        int startOffsetAdjustment = 0;
        AuthorDocumentController controller = authorAccess.getDocumentController();
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        int selStart = authorAccess.getEditorAccess().getSelectionStart();
        int selEnd = authorAccess.getEditorAccess().getSelectionEnd();
        int textStartOffset = -1;
        int textEndOffset = -1;
        String hexToConvert = null;
        if (selEnd < selStart) {
            int tmp = selStart;
            selStart = selEnd;
            selEnd = tmp;
        }
        if (selEnd > selStart) {
            TextContentIterator textContentIterator = controller.getTextContentIterator(selStart, selEnd - 1);
            if (textContentIterator.hasNext()) {
                TextContext tc = textContentIterator.next();
                hexToConvert = tc.getText().toString();
                textStartOffset = tc.getTextStartOffset();
                textEndOffset = tc.getTextEndOffset();
            }
            if (hexToConvert != null) {
                if (textStartOffset != -1 && selStart != textStartOffset || textEndOffset != -1 && selEnd != textEndOffset) {
                    validSelection = false;
                }
                if (validSelection) {
                    if (hexToConvert.length() > 6) {
                        validSelection = false;
                    } else {
                        for (int i = 0; i < hexToConvert.length(); ++i) {
                            char ch = Character.toLowerCase(hexToConvert.charAt(i));
                            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch == 'x') continue;
                            validSelection = false;
                            break;
                        }
                        if (validSelection) {
                            if (hexToConvert.toLowerCase().startsWith("0x")) {
                                hexToConvert = hexToConvert.substring(2);
                                startOffsetAdjustment = 2;
                            }
                            if (hexToConvert.toLowerCase().contains("x")) {
                                validSelection = false;
                            }
                        }
                    }
                }
            } else {
                validSelection = false;
            }
        } else {
            validSelection = false;
        }
        if (hexToConvert != null && validSelection && caretOffset == selStart) {
            caretOffset += selEnd - selStart;
        }
        StringBuilder hexDigits = new StringBuilder(6);
        if (hexToConvert == null) {
            TextContext tc;
            String str;
            char ch;
            TextContentIterator textContentIterator;
            for (int currPos = caretOffset; currPos > 0 && hexDigits.length() < 6 && (textContentIterator = controller.getTextContentIterator(currPos - 1, currPos - 1)).hasNext() && ((ch = Character.toLowerCase((str = (tc = textContentIterator.next()).getText().toString()).charAt(0))) >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch == 'x'); --currPos) {
                hexDigits.append(ch);
            }
        }
        int n = len = hexToConvert != null && validSelection ? hexToConvert.length() : hexDigits.length();
        if (len > 1) {
            if (hexToConvert == null) {
                hexToConvert = hexDigits.reverse().toString();
                int idx = hexToConvert.lastIndexOf("0x");
                if (idx != -1) {
                    hexToConvert = hexToConvert.substring(idx + 2);
                    startOffsetAdjustment = 2;
                } else {
                    int length = hexToConvert.length();
                    if (length > 4) {
                        hexToConvert = hexToConvert.substring(length - 4);
                    }
                }
                idx = hexToConvert.lastIndexOf(120);
                if (idx != -1) {
                    hexToConvert = hexToConvert.substring(idx + 1);
                    startOffsetAdjustment = 0;
                }
            }
            if ((len = hexToConvert.length()) > 1 && len <= 4) {
                try {
                    int value = NumberParserUtil.parseInt((String)hexToConvert, (int)16);
                    int startOffset = caretOffset - len - startOffsetAdjustment;
                    controller.delete(startOffset, caretOffset - 1);
                    controller.insertText(startOffset, "" + (char)value);
                }
                catch (NumberFormatException ex) {
                    authorAccess.getWorkspaceAccess().showErrorMessage(this.getErrorMessage());
                }
            } else {
                authorAccess.getWorkspaceAccess().showErrorMessage(this.getErrorMessage());
            }
        } else {
            authorAccess.getWorkspaceAccess().showErrorMessage(this.getErrorMessage());
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Converts a hexadecimal sequence of characters to a single Unicode character";
    }

    protected abstract String getErrorMessage();
}

