/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.xml.EscapingReader;
import ro.sync.basic.xml.UnescapeWriter;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.operations.ElementLocationPath;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class TransformOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)TransformOperation.class.getName());
    public static final String CURRENT_ELEMENT_LOCATION = "currentElementLocation";
    public static final String ACTION_REPLACE = "Replace";
    public static final String ACTION_AT_CARET = "At caret position";
    public static final String ACTION_INSERT_BEFORE = "Before";
    public static final String ACTION_INSERT_AFTER = "After";
    public static final String ACTION_INSERT_AS_FIRST_CHILD = "Inside as first child";
    public static final String ACTION_INSERT_AS_LAST_CHILD = "Inside as last child";
    public static final String CARET_POSITION_PRESERVE = "Preserve";
    public static final String CARET_POSITION_BEFORE = "Before";
    public static final String CARET_POSITION_START = "Start";
    public static final String CARET_POSITION_EDITABLE = "First editable position";
    public static final String CARET_POSITION_END = "End";
    public static final String CARET_POSITION_AFTER = "After";
    private static final String ARGUMENT_XPATH_SOURCE = "sourceLocation";
    private static final String ARGUMENT_XPATH_TARGET = "targetLocation";
    protected String ARGUMENT_SCRIPT = "script";
    private static final String ARGUMENT_ACTION = "action";
    private static final String ARGUMENT_CARET_POSITION = "caretPosition";
    private static final String ARGUMENT_EXPAND_EDITOR_VARIABLES = "expandEditorVariables";
    private static final String ARGUMENT_SUSPEND_TRACK_CHANGES = "suspendTrackChanges";
    private static final String ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_BEFORE_PROCCESSING = "alwaysPreserveTrackedChangesBeforeProcessing";
    private static final String ARGUMENT_ESCAPE_ENTITY_REFS = "escapeEntityRefs";
    public static final String ARGUMENT_SCRIPT_PARAMETERS = "externalParams";
    private static final Splitter SPLITTER_ON_COMMA_OR_END_LINE = Splitter.on((Pattern)Pattern.compile("[,\n]")).trimResults().omitEmptyStrings();
    private static final Splitter SPLITTER_ON_EQUALS = Splitter.on((String)"=").trimResults().omitEmptyStrings();
    private Map externalArguments = null;
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[10];

    public TransformOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_SOURCE, 2, "An XPath expression indicating the element that the script will be applied on.\nNote: If it is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_XPATH_TARGET, 2, "An XPath expression indicating the insert location for the result of the transformation.\nNote: If it is not defined then the insert location will be at the caret.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(this.ARGUMENT_SCRIPT, 4, "A path to the script or the script itself.\nWhen using a path the following apply:\n- a relative path is resolved to the framework directory. \n- the ${framework} editor variable can also be used to refer resources from the framework directory. \n- the path is passed through the catalog mappings.\nIf you provide the actual script, the base system ID for this will be the framework file, so any include/import reference will be resolved relative to the \".framework\" file that contains this action definition");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ACTION, 3, "The insert action relative to the node determined by the target XPath expression.\nIt can be: Replace, At caret position, Before, After, Inside as first child or Inside as last child.\n", new String[]{ACTION_REPLACE, ACTION_AT_CARET, "Before", "After", ACTION_INSERT_AS_FIRST_CHILD, ACTION_INSERT_AS_LAST_CHILD}, ACTION_REPLACE);
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_CARET_POSITION, 3, "The position of the caret after the action is executed.\nIt can be: Preserve, Before, Start, First editable position, End or After.\n", new String[]{CARET_POSITION_PRESERVE, "Before", CARET_POSITION_START, CARET_POSITION_EDITABLE, CARET_POSITION_END, "After"}, CARET_POSITION_EDITABLE);
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EXPAND_EDITOR_VARIABLES, 3, "Parameter controlling the expansion of editor variables returned by the script processing.\nExpansion is enabled by default.", new String[]{"true", "false"}, "true");
        this.arguments[6] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SUSPEND_TRACK_CHANGES, 0, "Disable Track Changes during the operation's execution.\nBy default the state of track changes is not altered.", new String[]{"true", "false"}, "false");
        this.arguments[7] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCRIPT_PARAMETERS, 0, "Provide external parameters to the script.\nShould be inserted as name=value pairs separated by comma or line break.");
        this.arguments[8] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_BEFORE_PROCCESSING, 0, "Always preserve tracked changes before processing, regardless of the track changes state.", new String[]{"true", "false"}, "false");
        this.arguments[9] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ESCAPE_ENTITY_REFS, 0, "Escape entity references in processed content to plain text and unescape them back in the returned content.", new String[]{"true", "false"}, "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        int endOffset;
        int index;
        StringWriter sw;
        AuthorNode chNode;
        String serializedDT;
        AuthorNode targetNode;
        AuthorElement sourceElement;
        Object xpathSource = args.getArgumentValue(ARGUMENT_XPATH_SOURCE);
        Object xpathTarget = args.getArgumentValue(ARGUMENT_XPATH_TARGET);
        Object xscript = args.getArgumentValue(this.ARGUMENT_SCRIPT);
        Object action = args.getArgumentValue(ARGUMENT_ACTION);
        Object caretPosition = args.getArgumentValue(ARGUMENT_CARET_POSITION);
        Object suspendTrackChangesArgument = args.getArgumentValue(ARGUMENT_SUSPEND_TRACK_CHANGES);
        Object alwaysPreserveTrackedChangesArgument = args.getArgumentValue(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_BEFORE_PROCCESSING);
        Object escapeEntityRefsVal = args.getArgumentValue(ARGUMENT_ESCAPE_ENTITY_REFS);
        boolean escapeEntityRefs = escapeEntityRefsVal == null || "true".equalsIgnoreCase(escapeEntityRefsVal.toString());
        Object paramsArgument = args.getArgumentValue(ARGUMENT_SCRIPT_PARAMETERS);
        if (!(xscript instanceof String)) {
            throw new IllegalArgumentException("The argument \"script\" was not defined as a string object!");
        }
        String script = (String)xscript;
        AuthorNode currentNode = null;
        AuthorElement currentElement = null;
        AuthorNode node = null;
        try {
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("Cannot identify the current node", (Throwable)e);
        }
        currentNode = node;
        for (node = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); node != null && !(node instanceof AuthorElement); node = node.getParent()) {
        }
        currentElement = node instanceof AuthorElement ? (AuthorElement)node : authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        if (xpathSource instanceof String && !"".equals(xpathSource)) {
            AuthorNode[] results = authorAccess.getDocumentController().findNodesByXPath((String)xpathSource, true, true, false);
            if (results.length <= 0 || !(results[0] instanceof AuthorElement)) throw new AuthorOperationException("The source XPath location does not identify an element: " + xpathSource);
            sourceElement = (AuthorElement)results[0];
        } else {
            sourceElement = currentElement;
        }
        ElementLocationPath currentElementLocation = ElementLocationPath.getCurrentElementLocation(authorAccess.getReviewController(), currentElement, sourceElement);
        String currentElementLocationXPath = currentElementLocation.toXPath();
        if (xpathTarget instanceof String && !"".equals(xpathTarget)) {
            AuthorNode[] results = authorAccess.getDocumentController().findNodesByXPath((String)xpathTarget, true, true, false);
            if (results.length <= 0) throw new AuthorOperationException("The target XPath location does not identify a node: " + xpathTarget);
            targetNode = results[0];
        } else {
            targetNode = currentNode;
        }
        String serializedFrag = null;
        StringBuilder serializedSource = new StringBuilder();
        try {
            boolean alwaysPreserveTrackedChanges = alwaysPreserveTrackedChangesArgument != null && "true".equalsIgnoreCase(alwaysPreserveTrackedChangesArgument.toString());
            AuthorDocumentFragment sourceFragment = alwaysPreserveTrackedChanges ? authorAccess.getDocumentController().createDocumentFragment(sourceElement.getStartOffset(), sourceElement.getEndOffset(), true) : authorAccess.getDocumentController().createDocumentFragment((AuthorNode)sourceElement, true);
            serializedFrag = authorAccess.getDocumentController().serializeFragmentToXML(sourceFragment);
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
            throw new AuthorOperationException("Could not serialize source", (Throwable)e);
        }
        if (serializedFrag == null) {
            throw new AuthorOperationException("Cannot serialize the source element: " + xpathSource);
        }
        AuthorDocumentType doctype = authorAccess.getDocumentController().getDoctype();
        if (doctype != null && (serializedDT = doctype.serializeDoctype()) != null) {
            serializedSource.append(serializedDT);
        }
        List contentNodes = authorAccess.getDocumentController().getAuthorDocumentNode().getContentNodes();
        for (int i = 0; i < contentNodes.size() && (chNode = (AuthorNode)contentNodes.get(i)).getType() != 0; ++i) {
            if (chNode.getType() != 5) continue;
            try {
                String piText = chNode.getTextContent();
                if (piText == null || !piText.startsWith("xml-model") && !piText.startsWith("oxygen")) continue;
                serializedSource.append("<?").append(piText).append("?>\n");
                continue;
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        serializedSource.append(serializedFrag);
        InputSource is = null;
        URL url = CommonsOperationsUtil.expandAndResolvePath(authorAccess, script);
        if (url != null) {
            is = new InputSource(url.toExternalForm());
        } else {
            if (!this.canTreatAsScript(script)) throw new AuthorOperationException("Could not find a location on disk corresponding to the 'script' parameter value: " + script);
            is = new InputSource(new StringReader(script));
            String baseLocation = authorAccess.getUtilAccess().expandEditorVariables("${framework}", authorAccess.getEditorAccess().getEditorLocation());
            if (baseLocation != null && baseLocation.contains("${framework}")) {
                baseLocation = authorAccess.getEditorAccess().getEditorLocation().toString();
            }
            is.setSystemId(baseLocation);
        }
        if (paramsArgument instanceof String && !((String)paramsArgument).trim().equals("")) {
            try {
                this.externalArguments = SPLITTER_ON_COMMA_OR_END_LINE.withKeyValueSeparator(SPLITTER_ON_EQUALS).split((CharSequence)String.valueOf(paramsArgument));
            }
            catch (IllegalArgumentException e) {
                throw new AuthorOperationException(e.getMessage());
            }
        }
        SAXSource xslSrc = new SAXSource(is);
        Transformer t = null;
        try {
            t = this.createTransformer(authorAccess, xslSrc, currentElementLocation);
        }
        catch (TransformerConfigurationException e) {
            logger.debug((Object)e, (Throwable)e);
            throw new AuthorOperationException("Cannot create a transformer from the provided script:\n" + script + "\nReason:" + e.getMessage());
        }
        if (t == null) return;
        t.setOutputProperty("indent", "no");
        t.setParameter(CURRENT_ELEMENT_LOCATION, currentElementLocationXPath);
        if (this.externalArguments != null) {
            for (Object key : this.externalArguments.keySet()) {
                t.setParameter((String)key, this.externalArguments.get(key));
            }
        }
        StringWriter writer = sw = new StringWriter();
        if (escapeEntityRefs) {
            writer = new UnescapeWriter((Writer)writer);
        }
        InputSource id = null;
        id = escapeEntityRefs ? new InputSource((Reader)new EscapingReader((Reader)new StringReader(serializedSource.toString()))) : new InputSource(new StringReader(serializedSource.toString()));
        id.setSystemId(sourceElement.getXMLBaseURL().toString());
        SAXSource xmlSrc = new SAXSource(id);
        try {
            t.transform(xmlSrc, new StreamResult(writer));
        }
        catch (TransformerException e) {
            logger.debug((Object)e, (Throwable)e);
            throw new AuthorOperationException("The script cannot be executed: " + e.getMessageAndLocation());
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        boolean expandEditorVariables = args.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES) == null || "true".equals(args.getArgumentValue(ARGUMENT_EXPAND_EDITOR_VARIABLES));
        boolean hasCaretMarker = false;
        Object result = sw.toString();
        if (((String)result).startsWith("<?xml ") && (index = ((String)result).indexOf("?>")) != -1) {
            result = ((String)result).substring(index + 2);
        }
        if (expandEditorVariables) {
            int indexOfCaret;
            int indexOfSelection = ((String)result).indexOf("${selection}");
            if (indexOfSelection != -1) {
                String selXML = "";
                try {
                    if (authorAccess.getEditorAccess().hasSelection()) {
                        AuthorDocumentFragment selFrag = authorAccess.getDocumentController().createDocumentFragment(authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd() - 1);
                        selXML = authorAccess.getDocumentController().serializeFragmentToXML(selFrag);
                    }
                }
                catch (BadLocationException ex) {
                    logger.error((Object)ex, (Throwable)ex);
                }
                result = ((String)result).substring(0, indexOfSelection) + selXML + ((String)result).substring(indexOfSelection + "${selection}".length(), ((String)result).length());
            }
            if ((indexOfCaret = ((String)(result = authorAccess.getUtilAccess().expandEditorVariables((String)result, authorAccess.getEditorAccess().getEditorLocation()))).indexOf("${caret}")) != -1) {
                result = ((String)result).substring(0, indexOfCaret) + "<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>" + ((String)result).substring(indexOfCaret + "${caret}".length(), ((String)result).length());
                hasCaretMarker = true;
            }
        }
        int offset = authorAccess.getEditorAccess().getCaretOffset();
        int insertionOffset = authorAccess.getEditorAccess().getCaretOffset();
        if (ACTION_REPLACE.equals(action)) {
            insertionOffset = targetNode.getStartOffset();
        } else if (!ACTION_AT_CARET.equals(action)) {
            String xpath = xpathTarget != null && ((String)xpathTarget).trim().length() > 0 ? (String)xpathTarget : ".";
            insertionOffset = authorAccess.getDocumentController().getXPathLocationOffset(xpath, (String)action);
        }
        Position endOffsetPos = null;
        try {
            endOffsetPos = authorAccess.getDocumentController().createPositionInContent(insertionOffset);
        }
        catch (BadLocationException e1) {
            logger.error((Object)e1, (Throwable)e1);
        }
        boolean shouldSuspendTC = false;
        if (authorAccess.getReviewController().isTrackingChanges() && Boolean.valueOf(suspendTrackChangesArgument.toString()).booleanValue()) {
            authorAccess.getReviewController().toggleTrackChanges();
            shouldSuspendTC = true;
        }
        try {
            if (ACTION_REPLACE.equals(action)) {
                if (targetNode.getType() == 2) {
                    targetNode = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
                }
                if (targetNode.getParent().getType() == 2) {
                    AuthorDocumentFragment authorFragment = authorAccess.getDocumentController().createNewDocumentFragmentInContext((String)result, targetNode.getStartOffset());
                    authorAccess.getDocumentController().replaceRoot(authorFragment);
                } else {
                    authorAccess.getDocumentController().insertXMLFragment((String)result, targetNode, "Before");
                    authorAccess.getDocumentController().deleteNode(targetNode);
                }
            } else if (ACTION_AT_CARET.equals(action)) {
                authorAccess.getDocumentController().insertXMLFragment((String)result, authorAccess.getEditorAccess().getCaretOffset());
            } else {
                authorAccess.getDocumentController().insertXMLFragment((String)result, targetNode, (String)action);
            }
        }
        finally {
            if (shouldSuspendTC) {
                authorAccess.getReviewController().toggleTrackChanges();
            }
        }
        int startOffset = insertionOffset + 1;
        int n = endOffset = endOffsetPos != null ? endOffsetPos.getOffset() - 1 : startOffset;
        if (offset < startOffset) {
            offset = startOffset;
        }
        if (offset > endOffset) {
            offset = endOffset;
        }
        if (hasCaretMarker) {
            MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, insertionOffset);
            return;
        }
        if ("Before".equals(caretPosition)) {
            authorAccess.getEditorAccess().setCaretPosition(startOffset - 1);
            return;
        }
        if (CARET_POSITION_START.equals(caretPosition)) {
            authorAccess.getEditorAccess().setCaretPosition(startOffset);
            return;
        }
        if (CARET_POSITION_PRESERVE.equals(caretPosition)) {
            authorAccess.getEditorAccess().setCaretPosition(offset);
            return;
        }
        if (CARET_POSITION_END.equals(caretPosition)) {
            authorAccess.getEditorAccess().setCaretPosition(endOffset);
            return;
        }
        if ("After".equals(caretPosition)) {
            authorAccess.getEditorAccess().setCaretPosition(endOffset + 1);
            return;
        }
        try {
            authorAccess.getEditorAccess().goToNextEditablePosition(startOffset - 1, endOffset);
            return;
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected boolean canTreatAsScript(String script) {
        return true;
    }

    protected abstract Transformer createTransformer(AuthorAccess var1, Source var2) throws TransformerConfigurationException;

    protected Transformer createTransformer(AuthorAccess authorAccess, Source scriptSrc, ElementLocationPath location) throws TransformerConfigurationException {
        return this.createTransformer(authorAccess, scriptSrc);
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Run a script on a source element and then replace or insert the result in a target node.";
    }
}

