/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.id.GenerateIDElementsInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SAIDElementsCustomizerDialog
extends OKCancelDialog {
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList listOfElements = new JList(this.listModel);
    private JCheckBox autoAssignElementIDs;
    private final JPanel listPanel;
    private final JButton addButton;
    private final JButton editButton;
    private final JButton removeButton;
    private final String listMessage;
    private final JTextField idGenerationPatternField = new JTextField();
    private JCheckBox filterIDsOnCopy;
    private final AuthorResourceBundle authorResourceBundle;

    public SAIDElementsCustomizerDialog(Frame parentFrame, String listMessage, AuthorResourceBundle authorResourceBundle) {
        this(parentFrame, listMessage, authorResourceBundle, false);
    }

    public SAIDElementsCustomizerDialog(Frame parentFrame, String listMessage, AuthorResourceBundle authorResourceBundle, boolean isDocBook) {
        super(parentFrame, authorResourceBundle.getMessage("ID_options"), true);
        this.listMessage = listMessage;
        this.authorResourceBundle = authorResourceBundle;
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.gridwidth = 1;
        constr.gridheight = 1;
        constr.weightx = 0.0;
        constr.weighty = 0.0;
        constr.fill = 0;
        constr.anchor = 17;
        constr.insets = new Insets(0, 0, 7, 5);
        JLabel patternLabel = new JLabel("ID Pattern:");
        mainPanel.add((Component)patternLabel, constr);
        ++constr.gridx;
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.insets = new Insets(0, 0, 7, 0);
        patternLabel.setLabelFor(this.idGenerationPatternField);
        mainPanel.add((Component)this.idGenerationPatternField, constr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 2;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.insets = new Insets(0, 0, 7, 0);
        this.listPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)this.listPanel, constr);
        GridBagConstraints listConstr = new GridBagConstraints();
        listConstr.gridx = 0;
        listConstr.gridy = 0;
        listConstr.gridwidth = 3;
        listConstr.gridheight = 1;
        listConstr.weightx = 1.0;
        listConstr.weighty = 0.0;
        listConstr.fill = 0;
        listConstr.anchor = 17;
        listConstr.insets = new Insets(0, 0, 5, 0);
        JLabel patternsListLabel = new JLabel(listMessage + ":");
        this.listPanel.add((Component)patternsListLabel, listConstr);
        listConstr.gridx = 0;
        ++listConstr.gridy;
        listConstr.weightx = 1.0;
        listConstr.weighty = 1.0;
        listConstr.fill = 1;
        listConstr.insets = new Insets(0, 0, 5, 0);
        JScrollPane scrollPane = new JScrollPane(this.listOfElements);
        scrollPane.setPreferredSize(new Dimension(300, 150));
        this.listPanel.add((Component)scrollPane, listConstr);
        patternsListLabel.setLabelFor(this.listOfElements);
        this.addButton = new JButton(new AbstractAction(authorResourceBundle.getMessage("Add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAIDElementsCustomizerDialog.this.addNewElement();
            }
        });
        listConstr.gridx = 0;
        ++listConstr.gridy;
        listConstr.gridwidth = 1;
        listConstr.weightx = 1.0;
        listConstr.weighty = 0.0;
        listConstr.fill = 0;
        listConstr.anchor = 13;
        listConstr.insets = new Insets(0, 0, 5, 5);
        this.listPanel.add((Component)this.addButton, listConstr);
        this.editButton = new JButton(new AbstractAction(authorResourceBundle.getMessage("Edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAIDElementsCustomizerDialog.this.editElement();
            }
        });
        ++listConstr.gridx;
        listConstr.weightx = 0.0;
        this.listPanel.add((Component)this.editButton, listConstr);
        this.removeButton = new JButton(new AbstractAction(authorResourceBundle.getMessage("Remove")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAIDElementsCustomizerDialog.this.removeElement();
            }
        });
        ++listConstr.gridx;
        listConstr.insets.right = 0;
        this.listPanel.add((Component)this.removeButton, listConstr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 2;
        constr.weightx = 1.0;
        constr.weighty = 0.0;
        constr.anchor = 17;
        constr.fill = 0;
        constr.insets = new Insets(0, 0, 7, 0);
        this.autoAssignElementIDs = new JCheckBox(authorResourceBundle.getMessage("Autogenerate_ids_for_elements"));
        this.autoAssignElementIDs.setBorder(BorderFactory.createEmptyBorder());
        mainPanel.add((Component)this.autoAssignElementIDs, constr);
        ++constr.gridy;
        String message = isDocBook ? authorResourceBundle.getMessage("Remove_ids_on_copy") : authorResourceBundle.getMessage("Remove_ids_on_copy_in_same_doc");
        this.filterIDsOnCopy = new JCheckBox(message);
        this.filterIDsOnCopy.setBorder(BorderFactory.createEmptyBorder());
        mainPanel.add((Component)this.filterIDsOnCopy, constr);
        this.add(mainPanel);
        this.setMinimumSize(new Dimension(400, 400));
        this.setResizable(true);
        this.listOfElements.setSelectionMode(0);
        this.listOfElements.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SAIDElementsCustomizerDialog.this.updateButtonState();
            }
        });
        this.updateButtonState();
    }

    private void updateButtonState() {
        int selectedIndex = this.listOfElements.getSelectedIndex();
        boolean selected = selectedIndex != -1;
        this.editButton.setEnabled(selected);
        this.removeButton.setEnabled(selected);
    }

    private void addNewElement() {
        String elem = JOptionPane.showInputDialog((Component)((Object)this), this.listMessage + ": ", this.authorResourceBundle.getMessage("Add"), -1);
        if (elem != null) {
            this.listModel.addElement(elem);
            this.listOfElements.setSelectedIndex(this.listModel.getSize() - 1);
        }
    }

    private void editElement() {
        String elem;
        int selectedIndex = this.listOfElements.getSelectedIndex();
        if (selectedIndex != -1 && (elem = (String)JOptionPane.showInputDialog((Component)((Object)this), this.listMessage + ": ", this.authorResourceBundle.getMessage("Edit"), -1, null, null, this.listModel.get(selectedIndex))) != null) {
            this.listModel.set(selectedIndex, elem);
        }
    }

    private void removeElement() {
        int selectedIndex = this.listOfElements.getSelectedIndex();
        if (selectedIndex != -1) {
            this.listModel.remove(selectedIndex);
            int size = this.listModel.getSize();
            if (size > 0) {
                if (selectedIndex < size) {
                    this.listOfElements.setSelectedIndex(selectedIndex);
                } else {
                    this.listOfElements.setSelectedIndex(size - 1);
                }
            }
        }
    }

    public GenerateIDElementsInfo showDialog(GenerateIDElementsInfo autoIDElementsInfo) {
        this.autoAssignElementIDs.setSelected(autoIDElementsInfo.isAutoGenerateIDs());
        this.idGenerationPatternField.setText(autoIDElementsInfo.getIdGenerationPattern());
        this.listModel.clear();
        String[] elements = autoIDElementsInfo.getElementsWithIDGeneration();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                this.listModel.addElement(elements[i]);
            }
        }
        this.filterIDsOnCopy.setSelected(autoIDElementsInfo.isFilterIDsOnCopy());
        this.updateButtonState();
        this.idGenerationPatternField.setToolTipText(autoIDElementsInfo.getPatternTooltip());
        this.setVisible(true);
        if (this.getResult() == 1) {
            Object[] elems = new String[this.listModel.getSize()];
            this.listModel.copyInto(elems);
            return new GenerateIDElementsInfo(this.autoAssignElementIDs.isSelected(), this.idGenerationPatternField.getText(), (String[])elems, this.filterIDsOnCopy.isSelected());
        }
        return null;
    }
}

