/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.impl.CoalescingTreeBuilder;
import nu.validator.htmlparser.impl.HtmlAttributes;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.basic.xml.dom.location.NodeRange;
import ro.sync.basic.xml.dom.location.SyntacticRange;

class DOMTreeBuilder
extends CoalescingTreeBuilder<Element> {
    private DOMImplementation implementation;
    private Document document;
    private Map<String, SyntacticRange> savedClosures = new HashMap<String, SyntacticRange>();
    private SyntacticRange savedTextRange = null;

    protected DOMTreeBuilder(DOMImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    protected void addAttributesToElement(Element element, HtmlAttributes attributes) throws SAXException {
        try {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String localName = attributes.getLocalName(i);
                String uri = attributes.getURI(i);
                if (element.hasAttributeNS(uri, localName)) continue;
                element.setAttributeNS(uri, localName, attributes.getValue(i));
                this.setLocationToAttr(element, localName, uri, attributes.getSyntactycRange(i));
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendCharacters(Element parent, String text) throws SAXException {
        try {
            Node lastChild = parent.getLastChild();
            if (lastChild != null && lastChild.getNodeType() == 3) {
                Text lastAsText = (Text)lastChild;
                lastAsText.setData(lastAsText.getData() + text);
                this.setLocationToNode(lastAsText, this.savedTextRange);
                return;
            }
            Text textNode = this.document.createTextNode(text);
            parent.appendChild(textNode);
            this.setLocationToNode(textNode, this.savedTextRange);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
        finally {
            this.savedTextRange = null;
        }
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        try {
            while (oldParent.hasChildNodes()) {
                newParent.appendChild(oldParent.getFirstChild());
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendComment(Element parent, String comment) throws SAXException {
        try {
            Comment c = this.document.createComment(comment);
            parent.appendChild(c);
            this.setLocationToNode(c, null);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendCommentToDocument(String comment) throws SAXException {
        try {
            Comment c = this.document.createComment(comment);
            this.setLocationToNode(c, null);
            this.document.appendChild(c);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes) throws SAXException {
        try {
            Element rv = this.document.createElementNS(ns, name);
            this.setLocationToNode(rv, null);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                this.setLocationToAttr(rv, attributes.getLocalName(i), attributes.getURI(i), attributes.getSyntactycRange(i));
                if (!"ID".equals(attributes.getType(i))) continue;
                rv.setIdAttributeNS(null, attributes.getLocalName(i), true);
            }
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        try {
            Element rv = this.document.createElementNS("http://www.w3.org/1999/xhtml", "html");
            this.setLocationToNode(rv, null);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                this.setLocationToAttr(rv, attributes.getLocalName(i), attributes.getURI(i), attributes.getSyntactycRange(i));
            }
            this.document.appendChild(rv);
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void appendElement(Element child, Element newParent) throws SAXException {
        try {
            newParent.appendChild(child);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected boolean hasChildren(Element element) throws SAXException {
        try {
            return element.hasChildNodes();
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes, Element form) throws SAXException {
        try {
            Element rv = this.createElement(ns, name, attributes);
            rv.setUserData("nu.validator.form-pointer", form, null);
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            return null;
        }
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        this.document = this.implementation.createDocument(null, null, null);
    }

    @Override
    protected void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        this.document.setUserData("nu.validator.document-mode", (Object)mode, null);
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    DocumentFragment getDocumentFragment() {
        DocumentFragment rv = this.document.createDocumentFragment();
        Node rootElt = this.document.getFirstChild();
        while (rootElt.hasChildNodes()) {
            rv.appendChild(rootElt.getFirstChild());
        }
        this.document = null;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void insertFosterParentedCharacters(String text, Element table, Element stackParent) throws SAXException {
        Text textNode;
        block18: {
            block19: {
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                block12: {
                                    block13: {
                                        textNode = null;
                                        try {
                                            Node parent = table.getParentNode();
                                            if (parent != null) {
                                                Node previousSibling = table.getPreviousSibling();
                                                if (previousSibling != null && previousSibling.getNodeType() == 3) {
                                                    Text lastAsText = (Text)previousSibling;
                                                    lastAsText.setData(lastAsText.getData() + text);
                                                    textNode = lastAsText;
                                                    if (textNode == null) break block12;
                                                    break block13;
                                                }
                                                textNode = this.document.createTextNode(text);
                                                parent.insertBefore(textNode, table);
                                                if (textNode == null) break block14;
                                                break block15;
                                            }
                                            Node lastChild = stackParent.getLastChild();
                                            if (lastChild != null && lastChild.getNodeType() == 3) {
                                                Text lastAsText = (Text)lastChild;
                                                lastAsText.setData(lastAsText.getData() + text);
                                                textNode = lastAsText;
                                                if (textNode == null) break block16;
                                                break block17;
                                            }
                                            textNode = this.document.createTextNode(text);
                                            stackParent.appendChild(textNode);
                                            if (textNode == null) break block18;
                                            break block19;
                                        }
                                        catch (DOMException e) {
                                            this.fatal(e);
                                            return;
                                        }
                                    }
                                    this.setLocationToNode(textNode, this.savedTextRange);
                                }
                                this.savedTextRange = null;
                                return;
                            }
                            this.setLocationToNode(textNode, this.savedTextRange);
                        }
                        this.savedTextRange = null;
                        return;
                    }
                    this.setLocationToNode(textNode, this.savedTextRange);
                }
                this.savedTextRange = null;
                return;
            }
            this.setLocationToNode(textNode, this.savedTextRange);
        }
        this.savedTextRange = null;
        return;
        finally {
            if (textNode != null) {
                this.setLocationToNode(textNode, this.savedTextRange);
            }
            this.savedTextRange = null;
        }
    }

    @Override
    protected void insertFosterParentedChild(Element child, Element table, Element stackParent) throws SAXException {
        try {
            Node parent = table.getParentNode();
            if (parent != null) {
                parent.insertBefore(child, table);
            } else {
                stackParent.appendChild(child);
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void detachFromParent(Element element) throws SAXException {
        try {
            Node parent = element.getParentNode();
            if (parent != null) {
                parent.removeChild(element);
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void elementPopped(String ns, String name, Element node) throws SAXException {
        SyntacticRange syntacticRange;
        NodeRange nodeRange = (NodeRange)BasicXmlUtil.getUserdata((Node)node, (String)"Ld");
        if (nodeRange != null && ((syntacticRange = this.savedClosures.remove(name)) != null || nodeRange.getEndElementSyntacticRange() == null)) {
            if (syntacticRange == null) {
                syntacticRange = new SyntacticRange(this.lastLocator.getLineNumber(), this.lastLocator.getColumnNumber(), this.lastLocator.getLineNumber(), this.lastLocator.getColumnNumber());
            }
            nodeRange.setEndElementSyntacticRange(this.getProperEndRange(nodeRange.getSyntacticRange(), syntacticRange));
            BasicXmlUtil.setUserdata((Node)node, (String)"Ld", (Object)nodeRange, null);
        }
    }

    private SyntacticRange getProperEndRange(SyntacticRange existingRange, SyntacticRange computedRange) {
        SyntacticRange properRange = computedRange;
        if (existingRange != null) {
            int existingEndLine = existingRange.getEndLine();
            int existingEndColumn = existingRange.getEndColumn();
            int computedEndLine = computedRange.getEndLine();
            int computedEndColumn = computedRange.getEndColumn();
            if (computedEndLine < existingEndLine || computedEndLine == existingEndLine && computedEndColumn < existingEndColumn) {
                properRange = existingRange;
            }
        }
        return properRange;
    }

    @Override
    protected void endTag(String elementName, int startLine, int startColumn, int endLine, int endColumn) {
        List elements = this.getOpenedElements();
        Collections.reverse(elements);
        for (Element element : elements) {
            if (elementName.equals(element.getNodeName())) {
                elements.clear();
                break;
            }
            NodeRange nodeRange = (NodeRange)BasicXmlUtil.getUserdata((Node)element, (String)"Ld");
            if (nodeRange == null || nodeRange.getEndElementSyntacticRange() != null) continue;
            nodeRange.setEndElementSyntacticRange(new SyntacticRange(startLine, startColumn, startLine, startColumn));
            BasicXmlUtil.setUserdata((Node)element, (String)"Ld", (Object)nodeRange, null);
        }
        this.savedClosures.put(elementName, new SyntacticRange(startLine, startColumn, endLine, endColumn));
    }

    @Override
    protected void characters(int startLine, int startColumn, int endLine, int endColumn) {
        if (this.savedTextRange != null && startLine == this.savedTextRange.getEndLine() && startColumn == this.savedTextRange.getEndColumn()) {
            startLine = this.savedTextRange.getStartLine();
            startColumn = this.savedTextRange.getStartColumn();
        }
        this.savedTextRange = new SyntacticRange(startLine, startColumn, endLine, endColumn);
    }

    protected void setLocationToNode(Node node, SyntacticRange imposedRange) {
        SyntacticRange syntacticRange = null;
        syntacticRange = imposedRange != null ? imposedRange : new SyntacticRange(this.lastLocator.getLineNumber(), this.lastLocator.getColumnNumber(), this.tokenizer.getLineNumber(), this.tokenizer.getColumnNumber());
        NodeRange nodeRange = new NodeRange(this.tokenizer.getSystemId());
        nodeRange.setSyntacticRange(syntacticRange);
        BasicXmlUtil.setUserdata((Node)node, (String)"Ld", (Object)nodeRange, null);
    }

    private void setLocationToAttr(Element element, String attrName, String attrURI, SyntacticRange range) {
        if (range != null) {
            Attr attr;
            Attr attr2 = attr = attrURI == null || "".equals(attrURI) ? element.getAttributeNode(attrName) : element.getAttributeNodeNS(attrURI, attrName);
            if (attr != null) {
                this.setLocationToNode(attr, range);
            }
        }
    }
}

